use std::{fs, env, process::exit};

use bytes::Bytes;
use dragino_lgt92_tools::decoder_1_6_7 as lgt92;

const PROGRAM_NAME: &'static str = "dragino_lgt92_decoder";

fn main() {
    let args: Vec<String> = env::args().collect();

    if args.len() == 1 {
	eprintln!("{}: argument required.", PROGRAM_NAME);
	exit(1);
    }

    let s: String = args[1].clone();

    match fs::read(&s) {
	Ok(f) => {
	    let b = Bytes::from(f);
	    println!("{:?}", b);
	    let p = lgt92::decode(&b);
	    println!("{:?}", p);
	}
	Err(m) => {
	    eprintln!("failed to open file {}.", s);
	    eprintln!("{:?}", m);

	    exit(1);
	}
    }
}
