#[derive(PartialEq, Debug, Clone, Copy)]
pub enum Alarm {
    Off = 0,
    On = 1
}

pub type Coordinate = f32;
pub type BatteryUnit = f32;
pub type Angle = f32;

#[derive(Debug, Clone, Copy)]
pub struct LGT92 {
    pub latitude: Coordinate,
    pub longitude: Coordinate,
    pub alarm: Alarm,
    pub battery: BatteryUnit,
    pub roll: Angle,
    pub pitch: Angle
}

impl From<u8> for Alarm {
    fn from(switch : u8) -> Self {
	match switch {
	    0 => { Alarm::Off }
	    1..=u8::MAX => { Alarm::On }
	}
    }
}

impl Into<u8> for Alarm {
    fn into(self: Self) -> u8 {
	match self {
	    Alarm::Off => { 0 }
	    Alarm::On => { 1 }
	}
    }
}
