pub mod lgt92;
pub mod decoder_1_6_7;

#[cfg(test)]
mod decode_tests {
    use bytes::Bytes;

    use crate::{lgt92::{Alarm, LGT92}, decoder_1_6_7 as decoder};

    #[test]
    fn decode() {
	let x: [u8; 15] = [0x02, 0x86, 0x3D, 0x68, // lat
			   0xFA, 0xC2, 0x9B, 0xAF, // long
			   0x4B, 0x45, // alarm & bat
			   0x60, // flag
			   0x04, 0xD2, // Roll
			   0xFB, 0x2F as u8]; // pitch

	let b = Bytes::from_iter(x);
	let p: LGT92 = decoder::decode(&b);

	assert_eq!(p.latitude, 42.351976);
	// NOTE: not sure if the example is right...
	assert_eq!(p.longitude, 3938.6226); // -87.909457
	assert_eq!(p.alarm, Alarm::On);
	assert_eq!(p.battery, 2885.0);
	assert_eq!(p.roll, 12.34);
	assert_eq!(p.pitch, -12.33);
    }
}
