`Dorea` 是一款使用 `Rust` 开发的高性能 Key-Value 存储系统。

## 存储模型

`Dorea` 使用了日志型存储方案：**Bitcask**

日志存储只有一种操作：**追加**，对于任何数据的处理都是追加完成的。

增、删 和 改 三种操作：它们在本系统中都是以一种追加的方式表示的。
这种存储的优点就是：它的写入效率非常之快，它不需要去定位数据存放在哪里、不需要编辑已有的信息。它做的仅仅是插入一条新的信息进去。
如果是对数据的删除，它也只是把一个特定的删除标识插入其中，用于让查找程序识别出信息是否被删除。

### 索引定位

在 `Dorea` 中，正在使用的库索引会被直接加载到 `内存` 中。

简单的解释一下：

本套系统支持多 `Group` 的设定。它类似于 `Redis` 中的 12 个数据库，但在 `Dorea` 中你可以创建更多数据库。
当一个数据库被加载时，它会从本地数据中加载索引信息（数据量不超过 10w+ 不会有太大延迟）。
同时系统还支持开发者在配置文件中定义 `默认加载库` 和 `最大索引量` 等信息。

#### 索引预载

!> :ghost: 这是一个开发中的功能！

我们将提供一个特殊的语句 `preload` 发起一个预加载要求。数据库系统会单独生成一条协程去加载这个库。
下一次我们再使用 `select` 切换到这个库时，它已经被预先处理好了（适用于数据量庞大的 `group` ）

#### 索引结构

```rust
struct IndexInfo {
    file_id: u32,
    start_position: u64,
    end_position: u64,
    time_stamp: (i64, u64),
}
```
上方是 `索引信息` 的存储结构体，它的内部信息是非常精简的。

- `file_id` 存储文件 ID
- `start_position` 数据在文件中的开始位置
- `end_position` 数据在文件中的结束位置
- `time_stamp` 数据生成时间及有效时间

除了 `time_stamp` 用于优化信息的过期处理以外，其他字段都是必不可少的！

## 数据结构

`Dorea 的数据结构比较简洁`，但也支持了基本类型与部分复合类型。

- String 字符串
- Number 数字
- Boolean 逻辑值
- Binary 二进制数据
- List 数组
- Dict 字典
- Tuple 元组

在 `Dorea` 中，复合类型是可以循环嵌套的：

```text
List
[
    [1, 2, 3]
    [4, 5, 6]
    [7, 8, 9]
]
```

具体内容会在正式章节中主要讨论到的。