# 数据类型

> Dorea 目前版本已经支持大部分常用基本类型和复合类型。

## 字符串

字符串是最重要的数据类型之一，它可以让我存放任何一段以字符组成的数据：

```
"hello" `简单的字符
"12345" `带数字的字符
"{"name": "mrxiaozhuox"}" `某种数据的序列化格式
"aGVsbG8gd29ybGQ=" `二进制数据也可以被序列化为字符串
```

它几乎可以涵盖任何内容和数据！**我愿称之为最强数据类型！**

它使用双引号`""` 来包裹。

## 数字值

在本系统中的 `数字` 类型使用了 `f64` 作存储，因为它同时支持：小数点、正负数、和整数。

```
18   `基本整数
3.14 `小数
18.0 `小数
-231 `负数
3.1415 `最多精确到后四位，后面的会被省略
```

`f64` 的最大值为：`1.7976931348623157e+308`

## 布尔值

布尔值即为逻辑值，逻辑值只区分 `真` 和 `假`，所以说他只有两个可能性：

```
true  真
false 假
```

## 二进制

这个类型是在 `Dorea-V0.3.0` 中引入的类型，它支持你直接存储被序列化的二进制数据。

```
binary!(
    PHAgYWxpZ249ImNlbnRlciI...
)
```

它使用 `Base64` 进行序列化，但是各语言的 SDK 都会对储存功能进行封装。**【本质上的存储方式为u8数组】**

## 列表集

`DoreaDB` 中的列表就是 `Array 数组`，你可以存储一系列的数据在里面：

```
[
    3.14,
    "string",
    false,
    binary!(...),
    [
        binary!(...),
        "hello world",
    ],
]
```

你可以在里面嵌套任何数据类型，包括嵌套一个新的列表。

> 这个类型可以被 `Edit` 命令操作和修改。

## 字典集

`DoreaDB` 中的字典就是 `Map 键值对`，你可以存储一系列的数据在里面（包含key）：

```
{
    "hello": "string",
    "pi": 3.14,
    "bin": binary!(...),
    "sub": {
        "name": "mrxiaozhuox",
        "age": 18
    }
}
```

你可以在里面嵌套任何数据类型，包括嵌套一个新的字典。

> 这个类型可以被 `Edit` 命令操作和修改。

## 元组集

元组就是只能存放两个数据的 `数组` ：

```
("LiuYuKun", 18)
("SongHaoXin": 18)
("XuGuanSen": 17)
("ZhouQiXiang": 17)
```

你可以在里面嵌套任何数据类型，包括嵌套一个新的元组。

## 数据风格

以上的数据结构都是使用 `Doson` 作为展示的，它是 `Json` 的变种，增加了一些语法，所以需要特殊的解析器。

但是 `Dorea` 支持你更换类型返回风格：

```
@default> value style json
[OK]: Successful
@default> get foo
[OK]: {"String": "bar"}
@default> get dict
[OK]: 
{
    "Dict": {
        "PI": {"Number": 3.14}, 
        "Bin": {"Binary": [...]}, 
        "Tuple": {"Tuple": [{...}, {...}]}
    }
}
```

目前 `doson` 的解析器只有 `Rust` 和 `Python` 语言提供了开发包，其他语言将使用 `Json` 进行解析。

### Web-Service 切换 Style

在 `Web-Service` 中需要选择 `Value Style` 只需要在 `Form` 中增加一条：

```
form: {
    style: "json", `这条用于更换 Style
    query: "....",
}
```