mod command;

use argh::FromArgs;

/// A simple dotfile manager
#[derive(Debug, FromArgs)]
struct Options {
    #[argh(subcommand)]
    command: Command,
}

#[derive(Debug, FromArgs)]
#[argh(subcommand)]
enum Command {
    Apply(command::apply::Options),
    Add(command::add::Options),
    Del(command::del::Options),
    Show(command::show::Options),
    Version(command::version::Options),
}

fn main() -> anyhow::Result<()> {
    let options: Options = argh::from_env();

    match options.command {
        Command::Apply(cmd) => cmd.run(),
        Command::Add(cmd) => cmd.run(),
        Command::Del(cmd) => cmd.run(),
        Command::Show(cmd) => cmd.run(),
        Command::Version(cmd) => cmd.run(),
    }
}
