use argh::FromArgs;

/// Print DoFi version
#[derive(Debug, FromArgs)]
#[argh(subcommand, name = "version")]
pub struct Options {}

impl Options {
    pub fn run(self) -> anyhow::Result<()> {
        Ok(println!(
            "DoFi {}",
            option_env!("DOFI_VERSION").unwrap_or(env!("CARGO_PKG_VERSION"))
        ))
    }
}
