use anyhow::Context;
use argh::FromArgs;
use dofi::profile::ProfileData;
use dofi::util::DoFi;

/// Show rules
#[derive(Debug, FromArgs)]
#[argh(subcommand, name = "show")]
pub struct Options {
    /// the profile name (default: default)
    #[argh(positional, default = "String::from(\"default\")")]
    profile: String,
    /// the rule name
    #[argh(option, short = 'r')]
    rule: Option<String>,
}

impl Options {
    pub fn run(self) -> anyhow::Result<()> {
        let p = ProfileData::from(self.profile)?;

        if let Some(k) = self.rule {
            let v = p
                .rules
                .get(&k)
                .with_context(|| format!("Not found rule [{}] in the profile [{}]", k, p.name))?;

            return v.show();
        }

        p.show()
    }
}
