use argh::FromArgs;
use dofi::profile::ProfileData;
use dofi::util::DoFi;

/// Delete a rule
#[derive(Debug, FromArgs)]
#[argh(subcommand, name = "del")]
pub struct Options {
    /// the rule name
    #[argh(positional)]
    rule: String,
    /// the profile name (default: default)
    #[argh(option, short = 'p', default = "String::from(\"default\")")]
    profile: String,
}

impl Options {
    pub fn run(self) -> anyhow::Result<()> {
        let mut p = ProfileData::from(self.profile)?;

        if let None = p.rules.get(&self.rule) {
            println!("The rule [{}] doesn't exist, do noting", &self.rule);
            return Ok(());
        }

        p.del(self.rule)
    }
}
