use clap::Parser;
use docktor_api_client::{Builder as ClientBuilder, Client as DApiClient, Config as ClientConfig};
use eyre::{bail, Result};
use http::HeaderValue;
use tracing::debug;

#[derive(Parser, Debug, Clone)]
pub struct Client {
    /// Docktor URL
    #[clap(short = 'U', long = "api-url", env("DOCKTOR_API_URL"))]
    pub api_url: String,
    /// API key
    #[clap(short = 'A', long = "api-key", env("DOCKTOR_API_KEY"))]
    pub api_key: String,
}

impl Client {
    pub async fn exec(&self) -> Result<()> {
        bail!("Not implemented yet")
    }
}

pub struct ApiClient(
    pub  DApiClient<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
);

impl ApiClient {
    pub fn new(api_url: String, api_key: String) -> Result<Self> {
        let mut raw_client = ClientBuilder::new()
            .rustls()
            .middleware_fn(move |mut req| {
                let http_req = req.http_mut();
                let uri = format!("{}/{}", api_url, http_req.uri().path());
                *http_req.uri_mut() = uri.parse().unwrap();
                debug!("Setting token authorization to 'Bearer: {}'", api_key);
                http_req.headers_mut().insert(
                    "Authorization",
                    HeaderValue::from_bytes(format!("Bearer {}", api_key).as_bytes()).unwrap(),
                );
                req
            })
            .build_dyn();
        raw_client.set_sleep_impl(None);
        let client_config = ClientConfig::builder().build();
        Ok(ApiClient(DApiClient::with_config(raw_client, client_config)))
    }
}
