// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::all)]
pub struct OperationRegistry<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5> {
    healthcheck_operation: Op0,
    list_operation: Op1,
    prometheus_target_operation: Op2,
    restart_operation: Op3,
    start_operation: Op4,
    stop_operation: Op5,
    _phantom: std::marker::PhantomData<(B, In0, In1, In2, In3, In4, In5)>,
}
#[allow(clippy::all)]
pub struct OperationRegistryBuilder<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5> {
    healthcheck_operation: Option<Op0>,
    list_operation: Option<Op1>,
    prometheus_target_operation: Option<Op2>,
    restart_operation: Option<Op3>,
    start_operation: Option<Op4>,
    stop_operation: Option<Op5>,
    _phantom: std::marker::PhantomData<(B, In0, In1, In2, In3, In4, In5)>,
}
#[derive(std::fmt::Debug)]
pub enum OperationRegistryBuilderError {
    UninitializedField(&'static str),
}
impl std::fmt::Display for OperationRegistryBuilderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Self::UninitializedField(v) => write!(f, "{}", v),
        }
    }
}
impl std::error::Error for OperationRegistryBuilderError {}
impl<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5> Default
    for OperationRegistryBuilder<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5>
{
    fn default() -> Self {
        Self {
            healthcheck_operation: Default::default(),
            list_operation: Default::default(),
            prometheus_target_operation: Default::default(),
            restart_operation: Default::default(),
            start_operation: Default::default(),
            stop_operation: Default::default(),
            _phantom: std::marker::PhantomData,
        }
    }
}
#[allow(clippy::all)]
impl<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5>
    OperationRegistryBuilder<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5>
{
    pub fn healthcheck_operation(self, value: Op0) -> Self {
        let mut new = self;
        new.healthcheck_operation = Some(value);
        new
    }
    pub fn list_operation(self, value: Op1) -> Self {
        let mut new = self;
        new.list_operation = Some(value);
        new
    }
    pub fn prometheus_target_operation(self, value: Op2) -> Self {
        let mut new = self;
        new.prometheus_target_operation = Some(value);
        new
    }
    pub fn restart_operation(self, value: Op3) -> Self {
        let mut new = self;
        new.restart_operation = Some(value);
        new
    }
    pub fn start_operation(self, value: Op4) -> Self {
        let mut new = self;
        new.start_operation = Some(value);
        new
    }
    pub fn stop_operation(self, value: Op5) -> Self {
        let mut new = self;
        new.stop_operation = Some(value);
        new
    }
    pub fn build(
        self,
    ) -> Result<
        OperationRegistry<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5>,
        OperationRegistryBuilderError,
    > {
        Ok(OperationRegistry {
            healthcheck_operation: match self.healthcheck_operation {
                Some(v) => v,
                None => {
                    return Err(OperationRegistryBuilderError::UninitializedField(
                        "healthcheck_operation",
                    ))
                }
            },
            list_operation: match self.list_operation {
                Some(v) => v,
                None => {
                    return Err(OperationRegistryBuilderError::UninitializedField(
                        "list_operation",
                    ))
                }
            },
            prometheus_target_operation: match self.prometheus_target_operation {
                Some(v) => v,
                None => {
                    return Err(OperationRegistryBuilderError::UninitializedField(
                        "prometheus_target_operation",
                    ))
                }
            },
            restart_operation: match self.restart_operation {
                Some(v) => v,
                None => {
                    return Err(OperationRegistryBuilderError::UninitializedField(
                        "restart_operation",
                    ))
                }
            },
            start_operation: match self.start_operation {
                Some(v) => v,
                None => {
                    return Err(OperationRegistryBuilderError::UninitializedField(
                        "start_operation",
                    ))
                }
            },
            stop_operation: match self.stop_operation {
                Some(v) => v,
                None => {
                    return Err(OperationRegistryBuilderError::UninitializedField(
                        "stop_operation",
                    ))
                }
            },
            _phantom: std::marker::PhantomData,
        })
    }
}
#[allow(clippy::all)]
impl<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5>
    From<OperationRegistry<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5>>
    for aws_smithy_http_server::routing::Router<B>
where
    B: Send + 'static,
    Op0: crate::server_operation_handler_trait::Handler<
        B,
        In0,
        crate::input::HealthcheckOperationInput,
    >,
    In0: 'static + Send,
    Op1: crate::server_operation_handler_trait::Handler<B, In1, crate::input::ListOperationInput>,
    In1: 'static + Send,
    Op2: crate::server_operation_handler_trait::Handler<
        B,
        In2,
        crate::input::PrometheusTargetOperationInput,
    >,
    In2: 'static + Send,
    Op3:
        crate::server_operation_handler_trait::Handler<B, In3, crate::input::RestartOperationInput>,
    In3: 'static + Send,
    Op4: crate::server_operation_handler_trait::Handler<B, In4, crate::input::StartOperationInput>,
    In4: 'static + Send,
    Op5: crate::server_operation_handler_trait::Handler<B, In5, crate::input::StopOperationInput>,
    In5: 'static + Send,
{
    fn from(
        registry: OperationRegistry<B, Op0, In0, Op1, In1, Op2, In2, Op3, In3, Op4, In4, Op5, In5>,
    ) -> Self {
        let healthcheck_operation_request_spec = aws_smithy_http_server::routing::request_spec::RequestSpec::new(
            http::Method::GET,
            aws_smithy_http_server::routing::request_spec::UriSpec::new(
                aws_smithy_http_server::routing::request_spec::PathAndQuerySpec::new(
                    aws_smithy_http_server::routing::request_spec::PathSpec::from_vector_unchecked(vec![aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("healthcheck"))]),
                    aws_smithy_http_server::routing::request_spec::QuerySpec::from_vector_unchecked(vec![])
                )
            )
        );
        let list_operation_request_spec = aws_smithy_http_server::routing::request_spec::RequestSpec::new(
            http::Method::GET,
            aws_smithy_http_server::routing::request_spec::UriSpec::new(
                aws_smithy_http_server::routing::request_spec::PathAndQuerySpec::new(
                    aws_smithy_http_server::routing::request_spec::PathSpec::from_vector_unchecked(vec![]),
                    aws_smithy_http_server::routing::request_spec::QuerySpec::from_vector_unchecked(vec![])
                )
            )
        );
        let prometheus_target_operation_request_spec = aws_smithy_http_server::routing::request_spec::RequestSpec::new(
            http::Method::GET,
            aws_smithy_http_server::routing::request_spec::UriSpec::new(
                aws_smithy_http_server::routing::request_spec::PathAndQuerySpec::new(
                    aws_smithy_http_server::routing::request_spec::PathSpec::from_vector_unchecked(vec![aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("prometheus")), aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("targets"))]),
                    aws_smithy_http_server::routing::request_spec::QuerySpec::from_vector_unchecked(vec![])
                )
            )
        );
        let restart_operation_request_spec = aws_smithy_http_server::routing::request_spec::RequestSpec::new(
            http::Method::POST,
            aws_smithy_http_server::routing::request_spec::UriSpec::new(
                aws_smithy_http_server::routing::request_spec::PathAndQuerySpec::new(
                    aws_smithy_http_server::routing::request_spec::PathSpec::from_vector_unchecked(vec![aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("systemd")), aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("restart"))]),
                    aws_smithy_http_server::routing::request_spec::QuerySpec::from_vector_unchecked(vec![])
                )
            )
        );
        let start_operation_request_spec = aws_smithy_http_server::routing::request_spec::RequestSpec::new(
            http::Method::POST,
            aws_smithy_http_server::routing::request_spec::UriSpec::new(
                aws_smithy_http_server::routing::request_spec::PathAndQuerySpec::new(
                    aws_smithy_http_server::routing::request_spec::PathSpec::from_vector_unchecked(vec![aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("systemd")), aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("start"))]),
                    aws_smithy_http_server::routing::request_spec::QuerySpec::from_vector_unchecked(vec![])
                )
            )
        );
        let stop_operation_request_spec = aws_smithy_http_server::routing::request_spec::RequestSpec::new(
            http::Method::POST,
            aws_smithy_http_server::routing::request_spec::UriSpec::new(
                aws_smithy_http_server::routing::request_spec::PathAndQuerySpec::new(
                    aws_smithy_http_server::routing::request_spec::PathSpec::from_vector_unchecked(vec![aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("systemd")), aws_smithy_http_server::routing::request_spec::PathSegment::Literal(String::from("stop"))]),
                    aws_smithy_http_server::routing::request_spec::QuerySpec::from_vector_unchecked(vec![])
                )
            )
        );
        aws_smithy_http_server::routing::Router::from_box_clone_service_iter(vec![
            (
                tower::util::BoxCloneService::new(
                    crate::server_operation_handler_trait::operation(
                        registry.healthcheck_operation,
                    ),
                ),
                healthcheck_operation_request_spec,
            ),
            (
                tower::util::BoxCloneService::new(
                    crate::server_operation_handler_trait::operation(registry.list_operation),
                ),
                list_operation_request_spec,
            ),
            (
                tower::util::BoxCloneService::new(
                    crate::server_operation_handler_trait::operation(
                        registry.prometheus_target_operation,
                    ),
                ),
                prometheus_target_operation_request_spec,
            ),
            (
                tower::util::BoxCloneService::new(
                    crate::server_operation_handler_trait::operation(registry.restart_operation),
                ),
                restart_operation_request_spec,
            ),
            (
                tower::util::BoxCloneService::new(
                    crate::server_operation_handler_trait::operation(registry.start_operation),
                ),
                start_operation_request_spec,
            ),
            (
                tower::util::BoxCloneService::new(
                    crate::server_operation_handler_trait::operation(registry.stop_operation),
                ),
                stop_operation_request_spec,
            ),
        ])
    }
}
