// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Single Prometheus target.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrometheusTarget {
    #[allow(missing_docs)] // documentation missing in model
    pub targets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Label mapping.
    pub labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PrometheusTarget {
    #[allow(missing_docs)] // documentation missing in model
    pub fn targets(&self) -> std::option::Option<&[std::string::String]> {
        self.targets.as_deref()
    }
    /// Label mapping.
    pub fn labels(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.labels.as_ref()
    }
}
impl std::fmt::Debug for PrometheusTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrometheusTarget");
        formatter.field("targets", &self.targets);
        formatter.field("labels", &self.labels);
        formatter.finish()
    }
}
/// See [`PrometheusTarget`](crate::model::PrometheusTarget)
pub mod prometheus_target {
    /// A builder for [`PrometheusTarget`](crate::model::PrometheusTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Adds a key-value pair to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// Label mapping.
        pub fn labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.labels = Some(hash_map);
            self
        }
        /// Label mapping.
        pub fn set_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Consumes the builder and constructs a [`PrometheusTarget`](crate::model::PrometheusTarget)
        pub fn build(self) -> crate::model::PrometheusTarget {
            crate::model::PrometheusTarget {
                targets: self.targets,
                labels: self.labels,
            }
        }
    }
}
impl PrometheusTarget {
    /// Creates a new builder-style object to manufacture [`PrometheusTarget`](crate::model::PrometheusTarget)
    pub fn builder() -> crate::model::prometheus_target::Builder {
        crate::model::prometheus_target::Builder::default()
    }
}

/// Systemd output structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemdOutputInner {
    /// Hostname
    pub hostname: std::option::Option<std::string::String>,
    /// Service name.
    pub service: std::option::Option<std::string::String>,
    /// Command output.
    pub output: std::option::Option<std::string::String>,
    /// Command error..
    pub error: std::option::Option<std::string::String>,
    /// Exit code.
    pub exit_code: std::option::Option<i64>,
}
impl SystemdOutputInner {
    /// Hostname
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// Service name.
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// Command output.
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// Command error..
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// Exit code.
    pub fn exit_code(&self) -> std::option::Option<i64> {
        self.exit_code
    }
}
impl std::fmt::Debug for SystemdOutputInner {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemdOutputInner");
        formatter.field("hostname", &self.hostname);
        formatter.field("service", &self.service);
        formatter.field("output", &self.output);
        formatter.field("error", &self.error);
        formatter.field("exit_code", &self.exit_code);
        formatter.finish()
    }
}
/// See [`SystemdOutputInner`](crate::model::SystemdOutputInner)
pub mod systemd_output_inner {
    /// A builder for [`SystemdOutputInner`](crate::model::SystemdOutputInner)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) exit_code: std::option::Option<i64>,
    }
    impl Builder {
        /// Hostname
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// Hostname
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// Service name.
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// Service name.
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// Command output.
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// Command output.
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// Command error..
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// Command error..
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Exit code.
        pub fn exit_code(mut self, input: i64) -> Self {
            self.exit_code = Some(input);
            self
        }
        /// Exit code.
        pub fn set_exit_code(mut self, input: std::option::Option<i64>) -> Self {
            self.exit_code = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemdOutputInner`](crate::model::SystemdOutputInner)
        pub fn build(self) -> crate::model::SystemdOutputInner {
            crate::model::SystemdOutputInner {
                hostname: self.hostname,
                service: self.service,
                output: self.output,
                error: self.error,
                exit_code: self.exit_code,
            }
        }
    }
}
impl SystemdOutputInner {
    /// Creates a new builder-style object to manufacture [`SystemdOutputInner`](crate::model::SystemdOutputInner)
    pub fn builder() -> crate::model::systemd_output_inner::Builder {
        crate::model::systemd_output_inner::Builder::default()
    }
}

/// ListOutpuut structure
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOutput {
    /// Is primary?
    pub primary: std::option::Option<std::string::String>,
    /// Host info.
    pub host: std::option::Option<crate::model::Host>,
    /// Host resources.
    pub resources: std::option::Option<crate::model::Resources>,
    /// List of available services.
    pub services: std::option::Option<std::vec::Vec<crate::model::Service>>,
    /// Service checksum.
    pub checksum: std::option::Option<std::string::String>,
    /// List of services runnable by this host
    pub available_services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Map of peers configurations
    pub peers: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ListOutput>,
    >,
}
impl ListOutput {
    /// Is primary?
    pub fn primary(&self) -> std::option::Option<&str> {
        self.primary.as_deref()
    }
    /// Host info.
    pub fn host(&self) -> std::option::Option<&crate::model::Host> {
        self.host.as_ref()
    }
    /// Host resources.
    pub fn resources(&self) -> std::option::Option<&crate::model::Resources> {
        self.resources.as_ref()
    }
    /// List of available services.
    pub fn services(&self) -> std::option::Option<&[crate::model::Service]> {
        self.services.as_deref()
    }
    /// Service checksum.
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// List of services runnable by this host
    pub fn available_services(&self) -> std::option::Option<&[std::string::String]> {
        self.available_services.as_deref()
    }
    /// Map of peers configurations
    pub fn peers(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ListOutput>,
    > {
        self.peers.as_ref()
    }
}
impl std::fmt::Debug for ListOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOutput");
        formatter.field("primary", &self.primary);
        formatter.field("host", &self.host);
        formatter.field("resources", &self.resources);
        formatter.field("services", &self.services);
        formatter.field("checksum", &self.checksum);
        formatter.field("available_services", &self.available_services);
        formatter.field("peers", &self.peers);
        formatter.finish()
    }
}
/// See [`ListOutput`](crate::model::ListOutput)
pub mod list_output {
    /// A builder for [`ListOutput`](crate::model::ListOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary: std::option::Option<std::string::String>,
        pub(crate) host: std::option::Option<crate::model::Host>,
        pub(crate) resources: std::option::Option<crate::model::Resources>,
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::Service>>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) available_services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) peers: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ListOutput>,
        >,
    }
    impl Builder {
        /// Is primary?
        pub fn primary(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary = Some(input.into());
            self
        }
        /// Is primary?
        pub fn set_primary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.primary = input;
            self
        }
        /// Host info.
        pub fn host(mut self, input: crate::model::Host) -> Self {
            self.host = Some(input);
            self
        }
        /// Host info.
        pub fn set_host(mut self, input: std::option::Option<crate::model::Host>) -> Self {
            self.host = input;
            self
        }
        /// Host resources.
        pub fn resources(mut self, input: crate::model::Resources) -> Self {
            self.resources = Some(input);
            self
        }
        /// Host resources.
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::Resources>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// List of available services.
        pub fn services(mut self, input: crate::model::Service) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input);
            self.services = Some(v);
            self
        }
        /// List of available services.
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Service>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Service checksum.
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// Service checksum.
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// Appends an item to `available_services`.
        ///
        /// To override the contents of this collection use [`set_available_services`](Self::set_available_services).
        ///
        /// List of services runnable by this host
        pub fn available_services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.available_services.unwrap_or_default();
            v.push(input.into());
            self.available_services = Some(v);
            self
        }
        /// List of services runnable by this host
        pub fn set_available_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.available_services = input;
            self
        }
        /// Adds a key-value pair to `peers`.
        ///
        /// To override the contents of this collection use [`set_peers`](Self::set_peers).
        ///
        /// Map of peers configurations
        pub fn peers(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ListOutput,
        ) -> Self {
            let mut hash_map = self.peers.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.peers = Some(hash_map);
            self
        }
        /// Map of peers configurations
        pub fn set_peers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ListOutput>,
            >,
        ) -> Self {
            self.peers = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOutput`](crate::model::ListOutput)
        pub fn build(self) -> crate::model::ListOutput {
            crate::model::ListOutput {
                primary: self.primary,
                host: self.host,
                resources: self.resources,
                services: self.services,
                checksum: self.checksum,
                available_services: self.available_services,
                peers: self.peers,
            }
        }
    }
}
impl ListOutput {
    /// Creates a new builder-style object to manufacture [`ListOutput`](crate::model::ListOutput)
    pub fn builder() -> crate::model::list_output::Builder {
        crate::model::list_output::Builder::default()
    }
}

/// Service view
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Service {
    /// Service unique ID.
    pub id: std::option::Option<std::string::String>,
    /// Container / process name.
    pub name: std::option::Option<std::string::String>,
    /// Service name.
    pub service: std::option::Option<std::string::String>,
    /// Pod for this service.
    pub pod: std::option::Option<std::string::String>,
    /// Host info.
    pub host: std::option::Option<crate::model::Host>,
    /// Weave info.
    pub weave: std::option::Option<crate::model::WeaveInfo>,
    /// HTTP port exposed.
    pub https: std::option::Option<std::vec::Vec<crate::model::Http>>,
    /// TCP port to expose on load balancer.
    pub tcps: std::option::Option<std::vec::Vec<crate::model::Tcp>>,
    /// TCP internal ports
    pub monitorings: std::option::Option<std::vec::Vec<crate::model::Monitoring>>,
    /// Status info
    pub healthcheck: std::option::Option<crate::model::Healthcheck>,
}
impl Service {
    /// Service unique ID.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// Container / process name.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Service name.
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// Pod for this service.
    pub fn pod(&self) -> std::option::Option<&str> {
        self.pod.as_deref()
    }
    /// Host info.
    pub fn host(&self) -> std::option::Option<&crate::model::Host> {
        self.host.as_ref()
    }
    /// Weave info.
    pub fn weave(&self) -> std::option::Option<&crate::model::WeaveInfo> {
        self.weave.as_ref()
    }
    /// HTTP port exposed.
    pub fn https(&self) -> std::option::Option<&[crate::model::Http]> {
        self.https.as_deref()
    }
    /// TCP port to expose on load balancer.
    pub fn tcps(&self) -> std::option::Option<&[crate::model::Tcp]> {
        self.tcps.as_deref()
    }
    /// TCP internal ports
    pub fn monitorings(&self) -> std::option::Option<&[crate::model::Monitoring]> {
        self.monitorings.as_deref()
    }
    /// Status info
    pub fn healthcheck(&self) -> std::option::Option<&crate::model::Healthcheck> {
        self.healthcheck.as_ref()
    }
}
impl std::fmt::Debug for Service {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Service");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("service", &self.service);
        formatter.field("pod", &self.pod);
        formatter.field("host", &self.host);
        formatter.field("weave", &self.weave);
        formatter.field("https", &self.https);
        formatter.field("tcps", &self.tcps);
        formatter.field("monitorings", &self.monitorings);
        formatter.field("healthcheck", &self.healthcheck);
        formatter.finish()
    }
}
/// See [`Service`](crate::model::Service)
pub mod service {
    /// A builder for [`Service`](crate::model::Service)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) pod: std::option::Option<std::string::String>,
        pub(crate) host: std::option::Option<crate::model::Host>,
        pub(crate) weave: std::option::Option<crate::model::WeaveInfo>,
        pub(crate) https: std::option::Option<std::vec::Vec<crate::model::Http>>,
        pub(crate) tcps: std::option::Option<std::vec::Vec<crate::model::Tcp>>,
        pub(crate) monitorings: std::option::Option<std::vec::Vec<crate::model::Monitoring>>,
        pub(crate) healthcheck: std::option::Option<crate::model::Healthcheck>,
    }
    impl Builder {
        /// Service unique ID.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// Service unique ID.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Container / process name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Container / process name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Service name.
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// Service name.
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// Pod for this service.
        pub fn pod(mut self, input: impl Into<std::string::String>) -> Self {
            self.pod = Some(input.into());
            self
        }
        /// Pod for this service.
        pub fn set_pod(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pod = input;
            self
        }
        /// Host info.
        pub fn host(mut self, input: crate::model::Host) -> Self {
            self.host = Some(input);
            self
        }
        /// Host info.
        pub fn set_host(mut self, input: std::option::Option<crate::model::Host>) -> Self {
            self.host = input;
            self
        }
        /// Weave info.
        pub fn weave(mut self, input: crate::model::WeaveInfo) -> Self {
            self.weave = Some(input);
            self
        }
        /// Weave info.
        pub fn set_weave(mut self, input: std::option::Option<crate::model::WeaveInfo>) -> Self {
            self.weave = input;
            self
        }
        /// Appends an item to `https`.
        ///
        /// To override the contents of this collection use [`set_https`](Self::set_https).
        ///
        /// HTTP port exposed.
        pub fn https(mut self, input: crate::model::Http) -> Self {
            let mut v = self.https.unwrap_or_default();
            v.push(input);
            self.https = Some(v);
            self
        }
        /// HTTP port exposed.
        pub fn set_https(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Http>>,
        ) -> Self {
            self.https = input;
            self
        }
        /// Appends an item to `tcps`.
        ///
        /// To override the contents of this collection use [`set_tcps`](Self::set_tcps).
        ///
        /// TCP port to expose on load balancer.
        pub fn tcps(mut self, input: crate::model::Tcp) -> Self {
            let mut v = self.tcps.unwrap_or_default();
            v.push(input);
            self.tcps = Some(v);
            self
        }
        /// TCP port to expose on load balancer.
        pub fn set_tcps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tcp>>,
        ) -> Self {
            self.tcps = input;
            self
        }
        /// Appends an item to `monitorings`.
        ///
        /// To override the contents of this collection use [`set_monitorings`](Self::set_monitorings).
        ///
        /// TCP internal ports
        pub fn monitorings(mut self, input: crate::model::Monitoring) -> Self {
            let mut v = self.monitorings.unwrap_or_default();
            v.push(input);
            self.monitorings = Some(v);
            self
        }
        /// TCP internal ports
        pub fn set_monitorings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Monitoring>>,
        ) -> Self {
            self.monitorings = input;
            self
        }
        /// Status info
        pub fn healthcheck(mut self, input: crate::model::Healthcheck) -> Self {
            self.healthcheck = Some(input);
            self
        }
        /// Status info
        pub fn set_healthcheck(
            mut self,
            input: std::option::Option<crate::model::Healthcheck>,
        ) -> Self {
            self.healthcheck = input;
            self
        }
        /// Consumes the builder and constructs a [`Service`](crate::model::Service)
        pub fn build(self) -> crate::model::Service {
            crate::model::Service {
                id: self.id,
                name: self.name,
                service: self.service,
                pod: self.pod,
                host: self.host,
                weave: self.weave,
                https: self.https,
                tcps: self.tcps,
                monitorings: self.monitorings,
                healthcheck: self.healthcheck,
            }
        }
    }
}
impl Service {
    /// Creates a new builder-style object to manufacture [`Service`](crate::model::Service)
    pub fn builder() -> crate::model::service::Builder {
        crate::model::service::Builder::default()
    }
}

/// Docker / system healthcheck result.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Healthcheck {
    /// Status message.
    pub message: std::option::Option<std::string::String>,
    /// Short status identifier.
    pub status: std::option::Option<std::string::String>,
    /// Exit code.
    pub exit_code: std::option::Option<i64>,
    /// How many failing tests so far.
    pub failing_streak: std::option::Option<i64>,
}
impl Healthcheck {
    /// Status message.
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// Short status identifier.
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// Exit code.
    pub fn exit_code(&self) -> std::option::Option<i64> {
        self.exit_code
    }
    /// How many failing tests so far.
    pub fn failing_streak(&self) -> std::option::Option<i64> {
        self.failing_streak
    }
}
impl std::fmt::Debug for Healthcheck {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Healthcheck");
        formatter.field("message", &self.message);
        formatter.field("status", &self.status);
        formatter.field("exit_code", &self.exit_code);
        formatter.field("failing_streak", &self.failing_streak);
        formatter.finish()
    }
}
/// See [`Healthcheck`](crate::model::Healthcheck)
pub mod healthcheck {
    /// A builder for [`Healthcheck`](crate::model::Healthcheck)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) exit_code: std::option::Option<i64>,
        pub(crate) failing_streak: std::option::Option<i64>,
    }
    impl Builder {
        /// Status message.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Status message.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Short status identifier.
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// Short status identifier.
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Exit code.
        pub fn exit_code(mut self, input: i64) -> Self {
            self.exit_code = Some(input);
            self
        }
        /// Exit code.
        pub fn set_exit_code(mut self, input: std::option::Option<i64>) -> Self {
            self.exit_code = input;
            self
        }
        /// How many failing tests so far.
        pub fn failing_streak(mut self, input: i64) -> Self {
            self.failing_streak = Some(input);
            self
        }
        /// How many failing tests so far.
        pub fn set_failing_streak(mut self, input: std::option::Option<i64>) -> Self {
            self.failing_streak = input;
            self
        }
        /// Consumes the builder and constructs a [`Healthcheck`](crate::model::Healthcheck)
        pub fn build(self) -> crate::model::Healthcheck {
            crate::model::Healthcheck {
                message: self.message,
                status: self.status,
                exit_code: self.exit_code,
                failing_streak: self.failing_streak,
            }
        }
    }
}
impl Healthcheck {
    /// Creates a new builder-style object to manufacture [`Healthcheck`](crate::model::Healthcheck)
    pub fn builder() -> crate::model::healthcheck::Builder {
        crate::model::healthcheck::Builder::default()
    }
}

/// Monitoring directives.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Monitoring {
    /// Prometheus host name.
    pub hostname: std::option::Option<std::string::String>,
    /// Prometheus monitoring URL.
    pub url: std::option::Option<std::string::String>,
    /// Prometheus monitoring port.
    pub port: std::option::Option<i16>,
}
impl Monitoring {
    /// Prometheus host name.
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// Prometheus monitoring URL.
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// Prometheus monitoring port.
    pub fn port(&self) -> std::option::Option<i16> {
        self.port
    }
}
impl std::fmt::Debug for Monitoring {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Monitoring");
        formatter.field("hostname", &self.hostname);
        formatter.field("url", &self.url);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`Monitoring`](crate::model::Monitoring)
pub mod monitoring {
    /// A builder for [`Monitoring`](crate::model::Monitoring)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i16>,
    }
    impl Builder {
        /// Prometheus host name.
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// Prometheus host name.
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// Prometheus monitoring URL.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// Prometheus monitoring URL.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Prometheus monitoring port.
        pub fn port(mut self, input: i16) -> Self {
            self.port = Some(input);
            self
        }
        /// Prometheus monitoring port.
        pub fn set_port(mut self, input: std::option::Option<i16>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`Monitoring`](crate::model::Monitoring)
        pub fn build(self) -> crate::model::Monitoring {
            crate::model::Monitoring {
                hostname: self.hostname,
                url: self.url,
                port: self.port,
            }
        }
    }
}
impl Monitoring {
    /// Creates a new builder-style object to manufacture [`Monitoring`](crate::model::Monitoring)
    pub fn builder() -> crate::model::monitoring::Builder {
        crate::model::monitoring::Builder::default()
    }
}

/// TCP directives.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tcp {
    /// External TCP port to bind.
    pub external: std::option::Option<i16>,
    /// Internal TCP port to forward.
    pub internal: std::option::Option<i16>,
}
impl Tcp {
    /// External TCP port to bind.
    pub fn external(&self) -> std::option::Option<i16> {
        self.external
    }
    /// Internal TCP port to forward.
    pub fn internal(&self) -> std::option::Option<i16> {
        self.internal
    }
}
impl std::fmt::Debug for Tcp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tcp");
        formatter.field("external", &self.external);
        formatter.field("internal", &self.internal);
        formatter.finish()
    }
}
/// See [`Tcp`](crate::model::Tcp)
pub mod tcp {
    /// A builder for [`Tcp`](crate::model::Tcp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external: std::option::Option<i16>,
        pub(crate) internal: std::option::Option<i16>,
    }
    impl Builder {
        /// External TCP port to bind.
        pub fn external(mut self, input: i16) -> Self {
            self.external = Some(input);
            self
        }
        /// External TCP port to bind.
        pub fn set_external(mut self, input: std::option::Option<i16>) -> Self {
            self.external = input;
            self
        }
        /// Internal TCP port to forward.
        pub fn internal(mut self, input: i16) -> Self {
            self.internal = Some(input);
            self
        }
        /// Internal TCP port to forward.
        pub fn set_internal(mut self, input: std::option::Option<i16>) -> Self {
            self.internal = input;
            self
        }
        /// Consumes the builder and constructs a [`Tcp`](crate::model::Tcp)
        pub fn build(self) -> crate::model::Tcp {
            crate::model::Tcp {
                external: self.external,
                internal: self.internal,
            }
        }
    }
}
impl Tcp {
    /// Creates a new builder-style object to manufacture [`Tcp`](crate::model::Tcp)
    pub fn builder() -> crate::model::tcp::Builder {
        crate::model::tcp::Builder::default()
    }
}

/// HTTP directives.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Http {
    /// HTTP port.
    pub port: std::option::Option<i16>,
    /// HTTP or HTTPS.
    pub verb: std::option::Option<std::string::String>,
    /// Use authorization.
    pub auth: std::option::Option<bool>,
}
impl Http {
    /// HTTP port.
    pub fn port(&self) -> std::option::Option<i16> {
        self.port
    }
    /// HTTP or HTTPS.
    pub fn verb(&self) -> std::option::Option<&str> {
        self.verb.as_deref()
    }
    /// Use authorization.
    pub fn auth(&self) -> std::option::Option<bool> {
        self.auth
    }
}
impl std::fmt::Debug for Http {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Http");
        formatter.field("port", &self.port);
        formatter.field("verb", &self.verb);
        formatter.field("auth", &self.auth);
        formatter.finish()
    }
}
/// See [`Http`](crate::model::Http)
pub mod http {
    /// A builder for [`Http`](crate::model::Http)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i16>,
        pub(crate) verb: std::option::Option<std::string::String>,
        pub(crate) auth: std::option::Option<bool>,
    }
    impl Builder {
        /// HTTP port.
        pub fn port(mut self, input: i16) -> Self {
            self.port = Some(input);
            self
        }
        /// HTTP port.
        pub fn set_port(mut self, input: std::option::Option<i16>) -> Self {
            self.port = input;
            self
        }
        /// HTTP or HTTPS.
        pub fn verb(mut self, input: impl Into<std::string::String>) -> Self {
            self.verb = Some(input.into());
            self
        }
        /// HTTP or HTTPS.
        pub fn set_verb(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.verb = input;
            self
        }
        /// Use authorization.
        pub fn auth(mut self, input: bool) -> Self {
            self.auth = Some(input);
            self
        }
        /// Use authorization.
        pub fn set_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.auth = input;
            self
        }
        /// Consumes the builder and constructs a [`Http`](crate::model::Http)
        pub fn build(self) -> crate::model::Http {
            crate::model::Http {
                port: self.port,
                verb: self.verb,
                auth: self.auth,
            }
        }
    }
}
impl Http {
    /// Creates a new builder-style object to manufacture [`Http`](crate::model::Http)
    pub fn builder() -> crate::model::http::Builder {
        crate::model::http::Builder::default()
    }
}

/// Weave domain and IP.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WeaveInfo {
    /// Domain.
    pub domain: std::option::Option<std::string::String>,
    /// IP address.
    pub ip: std::option::Option<std::string::String>,
}
impl WeaveInfo {
    /// Domain.
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// IP address.
    pub fn ip(&self) -> std::option::Option<&str> {
        self.ip.as_deref()
    }
}
impl std::fmt::Debug for WeaveInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WeaveInfo");
        formatter.field("domain", &self.domain);
        formatter.field("ip", &self.ip);
        formatter.finish()
    }
}
/// See [`WeaveInfo`](crate::model::WeaveInfo)
pub mod weave_info {
    /// A builder for [`WeaveInfo`](crate::model::WeaveInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Domain.
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// Domain.
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// IP address.
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// IP address.
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// Consumes the builder and constructs a [`WeaveInfo`](crate::model::WeaveInfo)
        pub fn build(self) -> crate::model::WeaveInfo {
            crate::model::WeaveInfo {
                domain: self.domain,
                ip: self.ip,
            }
        }
    }
}
impl WeaveInfo {
    /// Creates a new builder-style object to manufacture [`WeaveInfo`](crate::model::WeaveInfo)
    pub fn builder() -> crate::model::weave_info::Builder {
        crate::model::weave_info::Builder::default()
    }
}

/// Host information
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Host {
    /// Hostname running the service.
    pub hostname: std::option::Option<std::string::String>,
    /// Cluster domain
    pub domain: std::option::Option<std::string::String>,
}
impl Host {
    /// Hostname running the service.
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// Cluster domain
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
}
impl std::fmt::Debug for Host {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Host");
        formatter.field("hostname", &self.hostname);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`Host`](crate::model::Host)
pub mod host {
    /// A builder for [`Host`](crate::model::Host)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Hostname running the service.
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// Hostname running the service.
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// Cluster domain
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// Cluster domain
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`Host`](crate::model::Host)
        pub fn build(self) -> crate::model::Host {
            crate::model::Host {
                hostname: self.hostname,
                domain: self.domain,
            }
        }
    }
}
impl Host {
    /// Creates a new builder-style object to manufacture [`Host`](crate::model::Host)
    pub fn builder() -> crate::model::host::Builder {
        crate::model::host::Builder::default()
    }
}

/// Host resources
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resources {
    /// Number of CPUs.
    pub cpus: std::option::Option<i16>,
    /// Memory information,
    pub memory: std::option::Option<crate::model::Memory>,
    /// Load average.
    pub load_avg: std::option::Option<crate::model::LoadAvg>,
    /// Temoerature.
    pub temperature: std::option::Option<f32>,
}
impl Resources {
    /// Number of CPUs.
    pub fn cpus(&self) -> std::option::Option<i16> {
        self.cpus
    }
    /// Memory information,
    pub fn memory(&self) -> std::option::Option<&crate::model::Memory> {
        self.memory.as_ref()
    }
    /// Load average.
    pub fn load_avg(&self) -> std::option::Option<&crate::model::LoadAvg> {
        self.load_avg.as_ref()
    }
    /// Temoerature.
    pub fn temperature(&self) -> std::option::Option<f32> {
        self.temperature
    }
}
impl std::fmt::Debug for Resources {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resources");
        formatter.field("cpus", &self.cpus);
        formatter.field("memory", &self.memory);
        formatter.field("load_avg", &self.load_avg);
        formatter.field("temperature", &self.temperature);
        formatter.finish()
    }
}
/// See [`Resources`](crate::model::Resources)
pub mod resources {
    /// A builder for [`Resources`](crate::model::Resources)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpus: std::option::Option<i16>,
        pub(crate) memory: std::option::Option<crate::model::Memory>,
        pub(crate) load_avg: std::option::Option<crate::model::LoadAvg>,
        pub(crate) temperature: std::option::Option<f32>,
    }
    impl Builder {
        /// Number of CPUs.
        pub fn cpus(mut self, input: i16) -> Self {
            self.cpus = Some(input);
            self
        }
        /// Number of CPUs.
        pub fn set_cpus(mut self, input: std::option::Option<i16>) -> Self {
            self.cpus = input;
            self
        }
        /// Memory information,
        pub fn memory(mut self, input: crate::model::Memory) -> Self {
            self.memory = Some(input);
            self
        }
        /// Memory information,
        pub fn set_memory(mut self, input: std::option::Option<crate::model::Memory>) -> Self {
            self.memory = input;
            self
        }
        /// Load average.
        pub fn load_avg(mut self, input: crate::model::LoadAvg) -> Self {
            self.load_avg = Some(input);
            self
        }
        /// Load average.
        pub fn set_load_avg(mut self, input: std::option::Option<crate::model::LoadAvg>) -> Self {
            self.load_avg = input;
            self
        }
        /// Temoerature.
        pub fn temperature(mut self, input: f32) -> Self {
            self.temperature = Some(input);
            self
        }
        /// Temoerature.
        pub fn set_temperature(mut self, input: std::option::Option<f32>) -> Self {
            self.temperature = input;
            self
        }
        /// Consumes the builder and constructs a [`Resources`](crate::model::Resources)
        pub fn build(self) -> crate::model::Resources {
            crate::model::Resources {
                cpus: self.cpus,
                memory: self.memory,
                load_avg: self.load_avg,
                temperature: self.temperature,
            }
        }
    }
}
impl Resources {
    /// Creates a new builder-style object to manufacture [`Resources`](crate::model::Resources)
    pub fn builder() -> crate::model::resources::Builder {
        crate::model::resources::Builder::default()
    }
}

/// Load average representation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadAvg {
    /// One minute.
    pub one: std::option::Option<f32>,
    /// Five minutes.
    pub five: std::option::Option<f32>,
    /// Fifteen minutes.
    pub fifteen: std::option::Option<f32>,
}
impl LoadAvg {
    /// One minute.
    pub fn one(&self) -> std::option::Option<f32> {
        self.one
    }
    /// Five minutes.
    pub fn five(&self) -> std::option::Option<f32> {
        self.five
    }
    /// Fifteen minutes.
    pub fn fifteen(&self) -> std::option::Option<f32> {
        self.fifteen
    }
}
impl std::fmt::Debug for LoadAvg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadAvg");
        formatter.field("one", &self.one);
        formatter.field("five", &self.five);
        formatter.field("fifteen", &self.fifteen);
        formatter.finish()
    }
}
/// See [`LoadAvg`](crate::model::LoadAvg)
pub mod load_avg {
    /// A builder for [`LoadAvg`](crate::model::LoadAvg)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) one: std::option::Option<f32>,
        pub(crate) five: std::option::Option<f32>,
        pub(crate) fifteen: std::option::Option<f32>,
    }
    impl Builder {
        /// One minute.
        pub fn one(mut self, input: f32) -> Self {
            self.one = Some(input);
            self
        }
        /// One minute.
        pub fn set_one(mut self, input: std::option::Option<f32>) -> Self {
            self.one = input;
            self
        }
        /// Five minutes.
        pub fn five(mut self, input: f32) -> Self {
            self.five = Some(input);
            self
        }
        /// Five minutes.
        pub fn set_five(mut self, input: std::option::Option<f32>) -> Self {
            self.five = input;
            self
        }
        /// Fifteen minutes.
        pub fn fifteen(mut self, input: f32) -> Self {
            self.fifteen = Some(input);
            self
        }
        /// Fifteen minutes.
        pub fn set_fifteen(mut self, input: std::option::Option<f32>) -> Self {
            self.fifteen = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadAvg`](crate::model::LoadAvg)
        pub fn build(self) -> crate::model::LoadAvg {
            crate::model::LoadAvg {
                one: self.one,
                five: self.five,
                fifteen: self.fifteen,
            }
        }
    }
}
impl LoadAvg {
    /// Creates a new builder-style object to manufacture [`LoadAvg`](crate::model::LoadAvg)
    pub fn builder() -> crate::model::load_avg::Builder {
        crate::model::load_avg::Builder::default()
    }
}

/// Memory information.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Memory {
    /// Free memory.
    pub free: std::option::Option<f32>,
    /// Used memory.
    pub used: std::option::Option<f32>,
    /// Total memory.
    pub total: std::option::Option<f32>,
}
impl Memory {
    /// Free memory.
    pub fn free(&self) -> std::option::Option<f32> {
        self.free
    }
    /// Used memory.
    pub fn used(&self) -> std::option::Option<f32> {
        self.used
    }
    /// Total memory.
    pub fn total(&self) -> std::option::Option<f32> {
        self.total
    }
}
impl std::fmt::Debug for Memory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Memory");
        formatter.field("free", &self.free);
        formatter.field("used", &self.used);
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`Memory`](crate::model::Memory)
pub mod memory {
    /// A builder for [`Memory`](crate::model::Memory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) free: std::option::Option<f32>,
        pub(crate) used: std::option::Option<f32>,
        pub(crate) total: std::option::Option<f32>,
    }
    impl Builder {
        /// Free memory.
        pub fn free(mut self, input: f32) -> Self {
            self.free = Some(input);
            self
        }
        /// Free memory.
        pub fn set_free(mut self, input: std::option::Option<f32>) -> Self {
            self.free = input;
            self
        }
        /// Used memory.
        pub fn used(mut self, input: f32) -> Self {
            self.used = Some(input);
            self
        }
        /// Used memory.
        pub fn set_used(mut self, input: std::option::Option<f32>) -> Self {
            self.used = input;
            self
        }
        /// Total memory.
        pub fn total(mut self, input: f32) -> Self {
            self.total = Some(input);
            self
        }
        /// Total memory.
        pub fn set_total(mut self, input: std::option::Option<f32>) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`Memory`](crate::model::Memory)
        pub fn build(self) -> crate::model::Memory {
            crate::model::Memory {
                free: self.free,
                used: self.used,
                total: self.total,
            }
        }
    }
}
impl Memory {
    /// Creates a new builder-style object to manufacture [`Memory`](crate::model::Memory)
    pub fn builder() -> crate::model::memory::Builder {
        crate::model::memory::Builder::default()
    }
}
