// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `HealthcheckOperation` operation.
/// Each variant represents an error that can occur for the `HealthcheckOperation` operation.
#[derive(std::fmt::Debug)]
pub enum HealthcheckOperationError {
    /// Error coming from Prometheus.
    HealtcheckError(crate::error::HealtcheckError),
}
impl std::fmt::Display for HealthcheckOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self {
            HealthcheckOperationError::HealtcheckError(_inner) => _inner.fmt(f),
        }
    }
}
impl HealthcheckOperationError {
    /// Returns `true` if the error kind is `HealthcheckOperationError::HealtcheckError`.
    pub fn is_healtcheck_error(&self) -> bool {
        matches!(&self, HealthcheckOperationError::HealtcheckError(_))
    }
    /// Returns the error name string by matching the correct variant.
    pub fn name(&self) -> &'static str {
        match &self {
            HealthcheckOperationError::HealtcheckError(_inner) => _inner.name(),
        }
    }
}
impl std::error::Error for HealthcheckOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self {
            HealthcheckOperationError::HealtcheckError(_inner) => Some(_inner),
        }
    }
}

/// Error type for the `PrometheusTargetOperation` operation.
/// Each variant represents an error that can occur for the `PrometheusTargetOperation` operation.
#[derive(std::fmt::Debug)]
pub enum PrometheusTargetOperationError {
    /// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
    DocktorError(crate::error::DocktorError),
    /// Error coming from Prometheus.
    PrometheusError(crate::error::PrometheusError),
}
impl std::fmt::Display for PrometheusTargetOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self {
            PrometheusTargetOperationError::DocktorError(_inner) => _inner.fmt(f),
            PrometheusTargetOperationError::PrometheusError(_inner) => _inner.fmt(f),
        }
    }
}
impl PrometheusTargetOperationError {
    /// Returns `true` if the error kind is `PrometheusTargetOperationError::DocktorError`.
    pub fn is_docktor_error(&self) -> bool {
        matches!(&self, PrometheusTargetOperationError::DocktorError(_))
    }
    /// Returns `true` if the error kind is `PrometheusTargetOperationError::PrometheusError`.
    pub fn is_prometheus_error(&self) -> bool {
        matches!(&self, PrometheusTargetOperationError::PrometheusError(_))
    }
    /// Returns the error name string by matching the correct variant.
    pub fn name(&self) -> &'static str {
        match &self {
            PrometheusTargetOperationError::DocktorError(_inner) => _inner.name(),
            PrometheusTargetOperationError::PrometheusError(_inner) => _inner.name(),
        }
    }
}
impl std::error::Error for PrometheusTargetOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self {
            PrometheusTargetOperationError::DocktorError(_inner) => Some(_inner),
            PrometheusTargetOperationError::PrometheusError(_inner) => Some(_inner),
        }
    }
}

/// Error type for the `RestartOperation` operation.
/// Each variant represents an error that can occur for the `RestartOperation` operation.
#[derive(std::fmt::Debug)]
pub enum RestartOperationError {
    /// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
    DocktorError(crate::error::DocktorError),
    /// Error coming from Systemd.
    SystemdError(crate::error::SystemdError),
}
impl std::fmt::Display for RestartOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self {
            RestartOperationError::DocktorError(_inner) => _inner.fmt(f),
            RestartOperationError::SystemdError(_inner) => _inner.fmt(f),
        }
    }
}
impl RestartOperationError {
    /// Returns `true` if the error kind is `RestartOperationError::DocktorError`.
    pub fn is_docktor_error(&self) -> bool {
        matches!(&self, RestartOperationError::DocktorError(_))
    }
    /// Returns `true` if the error kind is `RestartOperationError::SystemdError`.
    pub fn is_systemd_error(&self) -> bool {
        matches!(&self, RestartOperationError::SystemdError(_))
    }
    /// Returns the error name string by matching the correct variant.
    pub fn name(&self) -> &'static str {
        match &self {
            RestartOperationError::DocktorError(_inner) => _inner.name(),
            RestartOperationError::SystemdError(_inner) => _inner.name(),
        }
    }
}
impl std::error::Error for RestartOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self {
            RestartOperationError::DocktorError(_inner) => Some(_inner),
            RestartOperationError::SystemdError(_inner) => Some(_inner),
        }
    }
}

/// Error type for the `StartOperation` operation.
/// Each variant represents an error that can occur for the `StartOperation` operation.
#[derive(std::fmt::Debug)]
pub enum StartOperationError {
    /// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
    DocktorError(crate::error::DocktorError),
    /// Error coming from Systemd.
    SystemdError(crate::error::SystemdError),
}
impl std::fmt::Display for StartOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self {
            StartOperationError::DocktorError(_inner) => _inner.fmt(f),
            StartOperationError::SystemdError(_inner) => _inner.fmt(f),
        }
    }
}
impl StartOperationError {
    /// Returns `true` if the error kind is `StartOperationError::DocktorError`.
    pub fn is_docktor_error(&self) -> bool {
        matches!(&self, StartOperationError::DocktorError(_))
    }
    /// Returns `true` if the error kind is `StartOperationError::SystemdError`.
    pub fn is_systemd_error(&self) -> bool {
        matches!(&self, StartOperationError::SystemdError(_))
    }
    /// Returns the error name string by matching the correct variant.
    pub fn name(&self) -> &'static str {
        match &self {
            StartOperationError::DocktorError(_inner) => _inner.name(),
            StartOperationError::SystemdError(_inner) => _inner.name(),
        }
    }
}
impl std::error::Error for StartOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self {
            StartOperationError::DocktorError(_inner) => Some(_inner),
            StartOperationError::SystemdError(_inner) => Some(_inner),
        }
    }
}

/// Error type for the `StopOperation` operation.
/// Each variant represents an error that can occur for the `StopOperation` operation.
#[derive(std::fmt::Debug)]
pub enum StopOperationError {
    /// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
    DocktorError(crate::error::DocktorError),
    /// Error coming from Systemd.
    SystemdError(crate::error::SystemdError),
}
impl std::fmt::Display for StopOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self {
            StopOperationError::DocktorError(_inner) => _inner.fmt(f),
            StopOperationError::SystemdError(_inner) => _inner.fmt(f),
        }
    }
}
impl StopOperationError {
    /// Returns `true` if the error kind is `StopOperationError::DocktorError`.
    pub fn is_docktor_error(&self) -> bool {
        matches!(&self, StopOperationError::DocktorError(_))
    }
    /// Returns `true` if the error kind is `StopOperationError::SystemdError`.
    pub fn is_systemd_error(&self) -> bool {
        matches!(&self, StopOperationError::SystemdError(_))
    }
    /// Returns the error name string by matching the correct variant.
    pub fn name(&self) -> &'static str {
        match &self {
            StopOperationError::DocktorError(_inner) => _inner.name(),
            StopOperationError::SystemdError(_inner) => _inner.name(),
        }
    }
}
impl std::error::Error for StopOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self {
            StopOperationError::DocktorError(_inner) => Some(_inner),
            StopOperationError::SystemdError(_inner) => Some(_inner),
        }
    }
}

/// Error coming from Prometheus.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrometheusError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PrometheusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrometheusError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PrometheusError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
    #[doc(hidden)]
    /// Returns the error name.
    pub fn name(&self) -> &'static str {
        "PrometheusError"
    }
}
impl std::fmt::Display for PrometheusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PrometheusError")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for PrometheusError {}
/// See [`PrometheusError`](crate::error::PrometheusError)
pub mod prometheus_error {
    /// A builder for [`PrometheusError`](crate::error::PrometheusError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PrometheusError`](crate::error::PrometheusError)
        pub fn build(self) -> crate::error::PrometheusError {
            crate::error::PrometheusError {
                message: self.message,
            }
        }
    }
}
impl PrometheusError {
    /// Creates a new builder-style object to manufacture [`PrometheusError`](crate::error::PrometheusError)
    pub fn builder() -> crate::error::prometheus_error::Builder {
        crate::error::prometheus_error::Builder::default()
    }
}

/// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocktorError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocktorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocktorError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DocktorError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
    #[doc(hidden)]
    /// Returns the error name.
    pub fn name(&self) -> &'static str {
        "DocktorError"
    }
}
impl std::fmt::Display for DocktorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DocktorError")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for DocktorError {}
/// See [`DocktorError`](crate::error::DocktorError)
pub mod docktor_error {
    /// A builder for [`DocktorError`](crate::error::DocktorError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DocktorError`](crate::error::DocktorError)
        pub fn build(self) -> crate::error::DocktorError {
            crate::error::DocktorError {
                message: self.message,
            }
        }
    }
}
impl DocktorError {
    /// Creates a new builder-style object to manufacture [`DocktorError`](crate::error::DocktorError)
    pub fn builder() -> crate::error::docktor_error::Builder {
        crate::error::docktor_error::Builder::default()
    }
}

/// Error coming from Systemd.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemdError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SystemdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemdError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SystemdError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
    #[doc(hidden)]
    /// Returns the error name.
    pub fn name(&self) -> &'static str {
        "SystemdError"
    }
}
impl std::fmt::Display for SystemdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SystemdError")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for SystemdError {}
/// See [`SystemdError`](crate::error::SystemdError)
pub mod systemd_error {
    /// A builder for [`SystemdError`](crate::error::SystemdError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemdError`](crate::error::SystemdError)
        pub fn build(self) -> crate::error::SystemdError {
            crate::error::SystemdError {
                message: self.message,
            }
        }
    }
}
impl SystemdError {
    /// Creates a new builder-style object to manufacture [`SystemdError`](crate::error::SystemdError)
    pub fn builder() -> crate::error::systemd_error::Builder {
        crate::error::systemd_error::Builder::default()
    }
}

/// Error coming from Prometheus.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealtcheckError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HealtcheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealtcheckError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HealtcheckError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
    #[doc(hidden)]
    /// Returns the error name.
    pub fn name(&self) -> &'static str {
        "HealtcheckError"
    }
}
impl std::fmt::Display for HealtcheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HealtcheckError")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for HealtcheckError {}
/// See [`HealtcheckError`](crate::error::HealtcheckError)
pub mod healtcheck_error {
    /// A builder for [`HealtcheckError`](crate::error::HealtcheckError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HealtcheckError`](crate::error::HealtcheckError)
        pub fn build(self) -> crate::error::HealtcheckError {
            crate::error::HealtcheckError {
                message: self.message,
            }
        }
    }
}
impl HealtcheckError {
    /// Creates a new builder-style object to manufacture [`HealtcheckError`](crate::error::HealtcheckError)
    pub fn builder() -> crate::error::healtcheck_error::Builder {
        crate::error::healtcheck_error::Builder::default()
    }
}
