// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Prometheus target output structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrometheusTargetOperationOutput {
    /// List of Prometheus targets.
    pub targets: std::option::Option<std::vec::Vec<crate::model::PrometheusTarget>>,
}
impl PrometheusTargetOperationOutput {
    /// List of Prometheus targets.
    pub fn targets(&self) -> std::option::Option<&[crate::model::PrometheusTarget]> {
        self.targets.as_deref()
    }
}
impl std::fmt::Debug for PrometheusTargetOperationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrometheusTargetOperationOutput");
        formatter.field("targets", &self.targets);
        formatter.finish()
    }
}
/// See [`PrometheusTargetOperationOutput`](crate::output::PrometheusTargetOperationOutput)
pub mod prometheus_target_operation_output {
    /// A builder for [`PrometheusTargetOperationOutput`](crate::output::PrometheusTargetOperationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::PrometheusTarget>>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// List of Prometheus targets.
        pub fn targets(mut self, input: crate::model::PrometheusTarget) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input);
            self.targets = Some(v);
            self
        }
        /// List of Prometheus targets.
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrometheusTarget>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Consumes the builder and constructs a [`PrometheusTargetOperationOutput`](crate::output::PrometheusTargetOperationOutput)
        pub fn build(self) -> crate::output::PrometheusTargetOperationOutput {
            crate::output::PrometheusTargetOperationOutput {
                targets: self.targets,
            }
        }
    }
}
impl PrometheusTargetOperationOutput {
    /// Creates a new builder-style object to manufacture [`PrometheusTargetOperationOutput`](crate::output::PrometheusTargetOperationOutput)
    pub fn builder() -> crate::output::prometheus_target_operation_output::Builder {
        crate::output::prometheus_target_operation_output::Builder::default()
    }
}

/// Systemd output structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestartOperationOutput {
    /// Systemd output list.
    pub inner: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
}
impl RestartOperationOutput {
    /// Systemd output list.
    pub fn inner(&self) -> std::option::Option<&[crate::model::SystemdOutputInner]> {
        self.inner.as_deref()
    }
}
impl std::fmt::Debug for RestartOperationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestartOperationOutput");
        formatter.field("inner", &self.inner);
        formatter.finish()
    }
}
/// See [`RestartOperationOutput`](crate::output::RestartOperationOutput)
pub mod restart_operation_output {
    /// A builder for [`RestartOperationOutput`](crate::output::RestartOperationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inner: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
    }
    impl Builder {
        /// Appends an item to `inner`.
        ///
        /// To override the contents of this collection use [`set_inner`](Self::set_inner).
        ///
        /// Systemd output list.
        pub fn inner(mut self, input: crate::model::SystemdOutputInner) -> Self {
            let mut v = self.inner.unwrap_or_default();
            v.push(input);
            self.inner = Some(v);
            self
        }
        /// Systemd output list.
        pub fn set_inner(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
        ) -> Self {
            self.inner = input;
            self
        }
        /// Consumes the builder and constructs a [`RestartOperationOutput`](crate::output::RestartOperationOutput)
        pub fn build(self) -> crate::output::RestartOperationOutput {
            crate::output::RestartOperationOutput { inner: self.inner }
        }
    }
}
impl RestartOperationOutput {
    /// Creates a new builder-style object to manufacture [`RestartOperationOutput`](crate::output::RestartOperationOutput)
    pub fn builder() -> crate::output::restart_operation_output::Builder {
        crate::output::restart_operation_output::Builder::default()
    }
}

/// Systemd output structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopOperationOutput {
    /// Systemd output list.
    pub inner: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
}
impl StopOperationOutput {
    /// Systemd output list.
    pub fn inner(&self) -> std::option::Option<&[crate::model::SystemdOutputInner]> {
        self.inner.as_deref()
    }
}
impl std::fmt::Debug for StopOperationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopOperationOutput");
        formatter.field("inner", &self.inner);
        formatter.finish()
    }
}
/// See [`StopOperationOutput`](crate::output::StopOperationOutput)
pub mod stop_operation_output {
    /// A builder for [`StopOperationOutput`](crate::output::StopOperationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inner: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
    }
    impl Builder {
        /// Appends an item to `inner`.
        ///
        /// To override the contents of this collection use [`set_inner`](Self::set_inner).
        ///
        /// Systemd output list.
        pub fn inner(mut self, input: crate::model::SystemdOutputInner) -> Self {
            let mut v = self.inner.unwrap_or_default();
            v.push(input);
            self.inner = Some(v);
            self
        }
        /// Systemd output list.
        pub fn set_inner(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
        ) -> Self {
            self.inner = input;
            self
        }
        /// Consumes the builder and constructs a [`StopOperationOutput`](crate::output::StopOperationOutput)
        pub fn build(self) -> crate::output::StopOperationOutput {
            crate::output::StopOperationOutput { inner: self.inner }
        }
    }
}
impl StopOperationOutput {
    /// Creates a new builder-style object to manufacture [`StopOperationOutput`](crate::output::StopOperationOutput)
    pub fn builder() -> crate::output::stop_operation_output::Builder {
        crate::output::stop_operation_output::Builder::default()
    }
}

/// Systemd output structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartOperationOutput {
    /// Systemd output list.
    pub inner: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
}
impl StartOperationOutput {
    /// Systemd output list.
    pub fn inner(&self) -> std::option::Option<&[crate::model::SystemdOutputInner]> {
        self.inner.as_deref()
    }
}
impl std::fmt::Debug for StartOperationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartOperationOutput");
        formatter.field("inner", &self.inner);
        formatter.finish()
    }
}
/// See [`StartOperationOutput`](crate::output::StartOperationOutput)
pub mod start_operation_output {
    /// A builder for [`StartOperationOutput`](crate::output::StartOperationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inner: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
    }
    impl Builder {
        /// Appends an item to `inner`.
        ///
        /// To override the contents of this collection use [`set_inner`](Self::set_inner).
        ///
        /// Systemd output list.
        pub fn inner(mut self, input: crate::model::SystemdOutputInner) -> Self {
            let mut v = self.inner.unwrap_or_default();
            v.push(input);
            self.inner = Some(v);
            self
        }
        /// Systemd output list.
        pub fn set_inner(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemdOutputInner>>,
        ) -> Self {
            self.inner = input;
            self
        }
        /// Consumes the builder and constructs a [`StartOperationOutput`](crate::output::StartOperationOutput)
        pub fn build(self) -> crate::output::StartOperationOutput {
            crate::output::StartOperationOutput { inner: self.inner }
        }
    }
}
impl StartOperationOutput {
    /// Creates a new builder-style object to manufacture [`StartOperationOutput`](crate::output::StartOperationOutput)
    pub fn builder() -> crate::output::start_operation_output::Builder {
        crate::output::start_operation_output::Builder::default()
    }
}

/// ListOutpuut structure
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOperationOutput {
    /// Is primary?
    pub primary: std::option::Option<std::string::String>,
    /// Host info.
    pub host: std::option::Option<crate::model::Host>,
    /// Host resources.
    pub resources: std::option::Option<crate::model::Resources>,
    /// List of available services.
    pub services: std::option::Option<std::vec::Vec<crate::model::Service>>,
    /// Service checksum.
    pub checksum: std::option::Option<std::string::String>,
    /// List of services runnable by this host
    pub available_services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Map of peers configurations
    pub peers: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ListOutput>,
    >,
}
impl ListOperationOutput {
    /// Is primary?
    pub fn primary(&self) -> std::option::Option<&str> {
        self.primary.as_deref()
    }
    /// Host info.
    pub fn host(&self) -> std::option::Option<&crate::model::Host> {
        self.host.as_ref()
    }
    /// Host resources.
    pub fn resources(&self) -> std::option::Option<&crate::model::Resources> {
        self.resources.as_ref()
    }
    /// List of available services.
    pub fn services(&self) -> std::option::Option<&[crate::model::Service]> {
        self.services.as_deref()
    }
    /// Service checksum.
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// List of services runnable by this host
    pub fn available_services(&self) -> std::option::Option<&[std::string::String]> {
        self.available_services.as_deref()
    }
    /// Map of peers configurations
    pub fn peers(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ListOutput>,
    > {
        self.peers.as_ref()
    }
}
impl std::fmt::Debug for ListOperationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOperationOutput");
        formatter.field("primary", &self.primary);
        formatter.field("host", &self.host);
        formatter.field("resources", &self.resources);
        formatter.field("services", &self.services);
        formatter.field("checksum", &self.checksum);
        formatter.field("available_services", &self.available_services);
        formatter.field("peers", &self.peers);
        formatter.finish()
    }
}
/// See [`ListOperationOutput`](crate::output::ListOperationOutput)
pub mod list_operation_output {
    /// A builder for [`ListOperationOutput`](crate::output::ListOperationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary: std::option::Option<std::string::String>,
        pub(crate) host: std::option::Option<crate::model::Host>,
        pub(crate) resources: std::option::Option<crate::model::Resources>,
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::Service>>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) available_services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) peers: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ListOutput>,
        >,
    }
    impl Builder {
        /// Is primary?
        pub fn primary(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary = Some(input.into());
            self
        }
        /// Is primary?
        pub fn set_primary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.primary = input;
            self
        }
        /// Host info.
        pub fn host(mut self, input: crate::model::Host) -> Self {
            self.host = Some(input);
            self
        }
        /// Host info.
        pub fn set_host(mut self, input: std::option::Option<crate::model::Host>) -> Self {
            self.host = input;
            self
        }
        /// Host resources.
        pub fn resources(mut self, input: crate::model::Resources) -> Self {
            self.resources = Some(input);
            self
        }
        /// Host resources.
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::Resources>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// List of available services.
        pub fn services(mut self, input: crate::model::Service) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input);
            self.services = Some(v);
            self
        }
        /// List of available services.
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Service>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Service checksum.
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// Service checksum.
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// Appends an item to `available_services`.
        ///
        /// To override the contents of this collection use [`set_available_services`](Self::set_available_services).
        ///
        /// List of services runnable by this host
        pub fn available_services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.available_services.unwrap_or_default();
            v.push(input.into());
            self.available_services = Some(v);
            self
        }
        /// List of services runnable by this host
        pub fn set_available_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.available_services = input;
            self
        }
        /// Adds a key-value pair to `peers`.
        ///
        /// To override the contents of this collection use [`set_peers`](Self::set_peers).
        ///
        /// Map of peers configurations
        pub fn peers(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ListOutput,
        ) -> Self {
            let mut hash_map = self.peers.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.peers = Some(hash_map);
            self
        }
        /// Map of peers configurations
        pub fn set_peers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ListOutput>,
            >,
        ) -> Self {
            self.peers = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOperationOutput`](crate::output::ListOperationOutput)
        pub fn build(self) -> crate::output::ListOperationOutput {
            crate::output::ListOperationOutput {
                primary: self.primary,
                host: self.host,
                resources: self.resources,
                services: self.services,
                checksum: self.checksum,
                available_services: self.available_services,
                peers: self.peers,
            }
        }
    }
}
impl ListOperationOutput {
    /// Creates a new builder-style object to manufacture [`ListOperationOutput`](crate::output::ListOperationOutput)
    pub fn builder() -> crate::output::list_operation_output::Builder {
        crate::output::list_operation_output::Builder::default()
    }
}

/// Service healthcheck output structure
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthcheckOperationOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl HealthcheckOperationOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for HealthcheckOperationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthcheckOperationOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`HealthcheckOperationOutput`](crate::output::HealthcheckOperationOutput)
pub mod healthcheck_operation_output {
    /// A builder for [`HealthcheckOperationOutput`](crate::output::HealthcheckOperationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthcheckOperationOutput`](crate::output::HealthcheckOperationOutput)
        pub fn build(self) -> crate::output::HealthcheckOperationOutput {
            crate::output::HealthcheckOperationOutput {
                message: self.message,
            }
        }
    }
}
impl HealthcheckOperationOutput {
    /// Creates a new builder-style object to manufacture [`HealthcheckOperationOutput`](crate::output::HealthcheckOperationOutput)
    pub fn builder() -> crate::output::healthcheck_operation_output::Builder {
        crate::output::healthcheck_operation_output::Builder::default()
    }
}
