// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_healthcheck_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::HealthcheckOperationOutput,
    crate::error::HealthcheckOperationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::HealthcheckOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::HealthcheckOperationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "HealtcheckError" => {
            crate::error::HealthcheckOperationError {
                meta: generic,
                kind: crate::error::HealthcheckOperationErrorKind::HealtcheckError({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::healtcheck_error::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_healtcheck_error_json_err(response.body().as_ref(), output).map_err(crate::error::HealthcheckOperationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::HealthcheckOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_healthcheck_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::HealthcheckOperationOutput,
    crate::error::HealthcheckOperationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::healthcheck_operation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_healthcheck_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::HealthcheckOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListOperationOutput, crate::error::ListOperationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListOperationError::unhandled)?;
    Err(crate::error::ListOperationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListOperationOutput, crate::error::ListOperationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_operation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_prometheus_target_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PrometheusTargetOperationOutput,
    crate::error::PrometheusTargetOperationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PrometheusTargetOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PrometheusTargetOperationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DocktorError" => crate::error::PrometheusTargetOperationError {
            meta: generic,
            kind: crate::error::PrometheusTargetOperationErrorKind::DocktorError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::docktor_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_docktor_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::PrometheusTargetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PrometheusError" => {
            crate::error::PrometheusTargetOperationError {
                meta: generic,
                kind: crate::error::PrometheusTargetOperationErrorKind::PrometheusError({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::prometheus_error::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_prometheus_error_json_err(response.body().as_ref(), output).map_err(crate::error::PrometheusTargetOperationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PrometheusTargetOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_prometheus_target_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PrometheusTargetOperationOutput,
    crate::error::PrometheusTargetOperationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::prometheus_target_operation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_prometheus_target_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PrometheusTargetOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restart_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestartOperationOutput, crate::error::RestartOperationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestartOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestartOperationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DocktorError" => crate::error::RestartOperationError {
            meta: generic,
            kind: crate::error::RestartOperationErrorKind::DocktorError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::docktor_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_docktor_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::RestartOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SystemdError" => crate::error::RestartOperationError {
            meta: generic,
            kind: crate::error::RestartOperationErrorKind::SystemdError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::systemd_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_systemd_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::RestartOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RestartOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restart_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestartOperationOutput, crate::error::RestartOperationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restart_operation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_restart_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RestartOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartOperationOutput, crate::error::StartOperationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartOperationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DocktorError" => crate::error::StartOperationError {
            meta: generic,
            kind: crate::error::StartOperationErrorKind::DocktorError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::docktor_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_docktor_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StartOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SystemdError" => crate::error::StartOperationError {
            meta: generic,
            kind: crate::error::StartOperationErrorKind::SystemdError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::systemd_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_systemd_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StartOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartOperationOutput, crate::error::StartOperationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_operation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopOperationOutput, crate::error::StopOperationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopOperationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DocktorError" => crate::error::StopOperationError {
            meta: generic,
            kind: crate::error::StopOperationErrorKind::DocktorError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::docktor_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_docktor_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StopOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SystemdError" => crate::error::StopOperationError {
            meta: generic,
            kind: crate::error::StopOperationErrorKind::SystemdError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::systemd_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_systemd_error_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StopOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopOperationOutput, crate::error::StopOperationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_operation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopOperationError::unhandled)?;
        output.build()
    })
}
