// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `HealthcheckOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`healthcheck_operation`](crate::client::Client::healthcheck_operation).
///
/// See [`crate::client::fluent_builders::HealthcheckOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct HealthcheckOperation {
    _private: (),
}
impl HealthcheckOperation {
    /// Creates a new builder-style object to manufacture [`HealthcheckOperationInput`](crate::input::HealthcheckOperationInput)
    pub fn builder() -> crate::input::healthcheck_operation_input::Builder {
        crate::input::healthcheck_operation_input::Builder::default()
    }
    /// Creates a new `HealthcheckOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for HealthcheckOperation {
    type Output = std::result::Result<
        crate::output::HealthcheckOperationOutput,
        crate::error::HealthcheckOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_healthcheck_operation_error(response)
        } else {
            crate::operation_deser::parse_healthcheck_operation_response(response)
        }
    }
}

/// Operation shape for `ListOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_operation`](crate::client::Client::list_operation).
///
/// See [`crate::client::fluent_builders::ListOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOperation {
    _private: (),
}
impl ListOperation {
    /// Creates a new builder-style object to manufacture [`ListOperationInput`](crate::input::ListOperationInput)
    pub fn builder() -> crate::input::list_operation_input::Builder {
        crate::input::list_operation_input::Builder::default()
    }
    /// Creates a new `ListOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOperation {
    type Output =
        std::result::Result<crate::output::ListOperationOutput, crate::error::ListOperationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_operation_error(response)
        } else {
            crate::operation_deser::parse_list_operation_response(response)
        }
    }
}

/// Operation shape for `PrometheusTargetOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`prometheus_target_operation`](crate::client::Client::prometheus_target_operation).
///
/// See [`crate::client::fluent_builders::PrometheusTargetOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PrometheusTargetOperation {
    _private: (),
}
impl PrometheusTargetOperation {
    /// Creates a new builder-style object to manufacture [`PrometheusTargetOperationInput`](crate::input::PrometheusTargetOperationInput)
    pub fn builder() -> crate::input::prometheus_target_operation_input::Builder {
        crate::input::prometheus_target_operation_input::Builder::default()
    }
    /// Creates a new `PrometheusTargetOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PrometheusTargetOperation {
    type Output = std::result::Result<
        crate::output::PrometheusTargetOperationOutput,
        crate::error::PrometheusTargetOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_prometheus_target_operation_error(response)
        } else {
            crate::operation_deser::parse_prometheus_target_operation_response(response)
        }
    }
}

/// Operation shape for `RestartOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restart_operation`](crate::client::Client::restart_operation).
///
/// See [`crate::client::fluent_builders::RestartOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestartOperation {
    _private: (),
}
impl RestartOperation {
    /// Creates a new builder-style object to manufacture [`RestartOperationInput`](crate::input::RestartOperationInput)
    pub fn builder() -> crate::input::restart_operation_input::Builder {
        crate::input::restart_operation_input::Builder::default()
    }
    /// Creates a new `RestartOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestartOperation {
    type Output = std::result::Result<
        crate::output::RestartOperationOutput,
        crate::error::RestartOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restart_operation_error(response)
        } else {
            crate::operation_deser::parse_restart_operation_response(response)
        }
    }
}

/// Operation shape for `StartOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_operation`](crate::client::Client::start_operation).
///
/// See [`crate::client::fluent_builders::StartOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartOperation {
    _private: (),
}
impl StartOperation {
    /// Creates a new builder-style object to manufacture [`StartOperationInput`](crate::input::StartOperationInput)
    pub fn builder() -> crate::input::start_operation_input::Builder {
        crate::input::start_operation_input::Builder::default()
    }
    /// Creates a new `StartOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartOperation {
    type Output =
        std::result::Result<crate::output::StartOperationOutput, crate::error::StartOperationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_operation_error(response)
        } else {
            crate::operation_deser::parse_start_operation_response(response)
        }
    }
}

/// Operation shape for `StopOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_operation`](crate::client::Client::stop_operation).
///
/// See [`crate::client::fluent_builders::StopOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopOperation {
    _private: (),
}
impl StopOperation {
    /// Creates a new builder-style object to manufacture [`StopOperationInput`](crate::input::StopOperationInput)
    pub fn builder() -> crate::input::stop_operation_input::Builder {
        crate::input::stop_operation_input::Builder::default()
    }
    /// Creates a new `StopOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopOperation {
    type Output =
        std::result::Result<crate::output::StopOperationOutput, crate::error::StopOperationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_operation_error(response)
        } else {
            crate::operation_deser::parse_stop_operation_response(response)
        }
    }
}
