// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`HealthcheckOperationInput`](crate::input::HealthcheckOperationInput)
pub mod healthcheck_operation_input {
    /// A builder for [`HealthcheckOperationInput`](crate::input::HealthcheckOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`HealthcheckOperationInput`](crate::input::HealthcheckOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::HealthcheckOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::HealthcheckOperationInput {})
        }
    }
}
#[doc(hidden)]
pub type HealthcheckOperationInputOperationOutputAlias = crate::operation::HealthcheckOperation;
#[doc(hidden)]
pub type HealthcheckOperationInputOperationRetryAlias = ();
impl HealthcheckOperationInput {
    /// Consumes the builder and constructs an Operation<[`HealthcheckOperation`](crate::operation::HealthcheckOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<crate::operation::HealthcheckOperation, ()>,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::HealthcheckOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/healthcheck").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::HealthcheckOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::HealthcheckOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::HealthcheckOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "HealthcheckOperation",
            "DocktorApi",
        ));
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`HealthcheckOperationInput`](crate::input::HealthcheckOperationInput)
    pub fn builder() -> crate::input::healthcheck_operation_input::Builder {
        crate::input::healthcheck_operation_input::Builder::default()
    }
}

/// See [`ListOperationInput`](crate::input::ListOperationInput)
pub mod list_operation_input {
    /// A builder for [`ListOperationInput`](crate::input::ListOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListOperationInput`](crate::input::ListOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOperationInput {})
        }
    }
}
#[doc(hidden)]
pub type ListOperationInputOperationOutputAlias = crate::operation::ListOperation;
#[doc(hidden)]
pub type ListOperationInputOperationRetryAlias = ();
impl ListOperationInput {
    /// Consumes the builder and constructs an Operation<[`ListOperation`](crate::operation::ListOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<crate::operation::ListOperation, ()>,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOperation",
            "DocktorApi",
        ));
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOperationInput`](crate::input::ListOperationInput)
    pub fn builder() -> crate::input::list_operation_input::Builder {
        crate::input::list_operation_input::Builder::default()
    }
}

/// See [`PrometheusTargetOperationInput`](crate::input::PrometheusTargetOperationInput)
pub mod prometheus_target_operation_input {
    /// A builder for [`PrometheusTargetOperationInput`](crate::input::PrometheusTargetOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PrometheusTargetOperationInput`](crate::input::PrometheusTargetOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PrometheusTargetOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PrometheusTargetOperationInput {})
        }
    }
}
#[doc(hidden)]
pub type PrometheusTargetOperationInputOperationOutputAlias =
    crate::operation::PrometheusTargetOperation;
#[doc(hidden)]
pub type PrometheusTargetOperationInputOperationRetryAlias = ();
impl PrometheusTargetOperationInput {
    /// Consumes the builder and constructs an Operation<[`PrometheusTargetOperation`](crate::operation::PrometheusTargetOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<crate::operation::PrometheusTargetOperation, ()>,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PrometheusTargetOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prometheus/targets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PrometheusTargetOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PrometheusTargetOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PrometheusTargetOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PrometheusTargetOperation",
            "DocktorApi",
        ));
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PrometheusTargetOperationInput`](crate::input::PrometheusTargetOperationInput)
    pub fn builder() -> crate::input::prometheus_target_operation_input::Builder {
        crate::input::prometheus_target_operation_input::Builder::default()
    }
}

/// See [`RestartOperationInput`](crate::input::RestartOperationInput)
pub mod restart_operation_input {
    /// A builder for [`RestartOperationInput`](crate::input::RestartOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hostname: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// Service name.
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// Service name.
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Hostname.
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// Hostname.
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// Consumes the builder and constructs a [`RestartOperationInput`](crate::input::RestartOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestartOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestartOperationInput {
                services: self.services,
                hostname: self.hostname,
            })
        }
    }
}
#[doc(hidden)]
pub type RestartOperationInputOperationOutputAlias = crate::operation::RestartOperation;
#[doc(hidden)]
pub type RestartOperationInputOperationRetryAlias = ();
impl RestartOperationInput {
    /// Consumes the builder and constructs an Operation<[`RestartOperation`](crate::operation::RestartOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<crate::operation::RestartOperation, ()>,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestartOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/systemd/restart").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestartOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestartOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restart_operation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestartOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestartOperation",
            "DocktorApi",
        ));
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestartOperationInput`](crate::input::RestartOperationInput)
    pub fn builder() -> crate::input::restart_operation_input::Builder {
        crate::input::restart_operation_input::Builder::default()
    }
}

/// See [`StartOperationInput`](crate::input::StartOperationInput)
pub mod start_operation_input {
    /// A builder for [`StartOperationInput`](crate::input::StartOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hostname: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// Service name.
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// Service name.
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Hostname.
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// Hostname.
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// Consumes the builder and constructs a [`StartOperationInput`](crate::input::StartOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartOperationInput {
                services: self.services,
                hostname: self.hostname,
            })
        }
    }
}
#[doc(hidden)]
pub type StartOperationInputOperationOutputAlias = crate::operation::StartOperation;
#[doc(hidden)]
pub type StartOperationInputOperationRetryAlias = ();
impl StartOperationInput {
    /// Consumes the builder and constructs an Operation<[`StartOperation`](crate::operation::StartOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<crate::operation::StartOperation, ()>,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/systemd/start").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_operation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartOperation",
            "DocktorApi",
        ));
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartOperationInput`](crate::input::StartOperationInput)
    pub fn builder() -> crate::input::start_operation_input::Builder {
        crate::input::start_operation_input::Builder::default()
    }
}

/// See [`StopOperationInput`](crate::input::StopOperationInput)
pub mod stop_operation_input {
    /// A builder for [`StopOperationInput`](crate::input::StopOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hostname: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// Service name.
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// Service name.
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Hostname.
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// Hostname.
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// Consumes the builder and constructs a [`StopOperationInput`](crate::input::StopOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopOperationInput {
                services: self.services,
                hostname: self.hostname,
            })
        }
    }
}
#[doc(hidden)]
pub type StopOperationInputOperationOutputAlias = crate::operation::StopOperation;
#[doc(hidden)]
pub type StopOperationInputOperationRetryAlias = ();
impl StopOperationInput {
    /// Consumes the builder and constructs an Operation<[`StopOperation`](crate::operation::StopOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<crate::operation::StopOperation, ()>,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/systemd/stop").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_operation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopOperation",
            "DocktorApi",
        ));
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopOperationInput`](crate::input::StopOperationInput)
    pub fn builder() -> crate::input::stop_operation_input::Builder {
        crate::input::stop_operation_input::Builder::default()
    }
}

/// Prometheus target input structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrometheusTargetOperationInput {}
impl std::fmt::Debug for PrometheusTargetOperationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrometheusTargetOperationInput");
        formatter.finish()
    }
}

/// Systemd input structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestartOperationInput {
    /// Service name.
    pub services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Hostname.
    pub hostname: std::option::Option<std::string::String>,
}
impl RestartOperationInput {
    /// Service name.
    pub fn services(&self) -> std::option::Option<&[std::string::String]> {
        self.services.as_deref()
    }
    /// Hostname.
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
}
impl std::fmt::Debug for RestartOperationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestartOperationInput");
        formatter.field("services", &self.services);
        formatter.field("hostname", &self.hostname);
        formatter.finish()
    }
}

/// Systemd input structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopOperationInput {
    /// Service name.
    pub services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Hostname.
    pub hostname: std::option::Option<std::string::String>,
}
impl StopOperationInput {
    /// Service name.
    pub fn services(&self) -> std::option::Option<&[std::string::String]> {
        self.services.as_deref()
    }
    /// Hostname.
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
}
impl std::fmt::Debug for StopOperationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopOperationInput");
        formatter.field("services", &self.services);
        formatter.field("hostname", &self.hostname);
        formatter.finish()
    }
}

/// Systemd input structure.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartOperationInput {
    /// Service name.
    pub services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Hostname.
    pub hostname: std::option::Option<std::string::String>,
}
impl StartOperationInput {
    /// Service name.
    pub fn services(&self) -> std::option::Option<&[std::string::String]> {
        self.services.as_deref()
    }
    /// Hostname.
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
}
impl std::fmt::Debug for StartOperationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartOperationInput");
        formatter.field("services", &self.services);
        formatter.field("hostname", &self.hostname);
        formatter.finish()
    }
}

/// ListInput structure
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOperationInput {}
impl std::fmt::Debug for ListOperationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOperationInput");
        formatter.finish()
    }
}

/// //////////////////////////////////// Model //////////////////////////////////// Service healthcheck input structure
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthcheckOperationInput {}
impl std::fmt::Debug for HealthcheckOperationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthcheckOperationInput");
        formatter.finish()
    }
}
