// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `HealthcheckOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct HealthcheckOperationError {
    /// Kind of error that occurred.
    pub kind: HealthcheckOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `HealthcheckOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum HealthcheckOperationErrorKind {
    /// Error coming from Prometheus.
    HealtcheckError(crate::error::HealtcheckError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for HealthcheckOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            HealthcheckOperationErrorKind::HealtcheckError(_inner) => _inner.fmt(f),
            HealthcheckOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for HealthcheckOperationError {
    fn code(&self) -> Option<&str> {
        HealthcheckOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl HealthcheckOperationError {
    /// Creates a new `HealthcheckOperationError`.
    pub fn new(kind: HealthcheckOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `HealthcheckOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: HealthcheckOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `HealthcheckOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: HealthcheckOperationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `HealthcheckOperationErrorKind::HealtcheckError`.
    pub fn is_healtcheck_error(&self) -> bool {
        matches!(
            &self.kind,
            HealthcheckOperationErrorKind::HealtcheckError(_)
        )
    }
}
impl std::error::Error for HealthcheckOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            HealthcheckOperationErrorKind::HealtcheckError(_inner) => Some(_inner),
            HealthcheckOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOperationError {
    /// Kind of error that occurred.
    pub kind: ListOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOperationErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOperationError {
    fn code(&self) -> Option<&str> {
        ListOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOperationError {
    /// Creates a new `ListOperationError`.
    pub fn new(kind: ListOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOperationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PrometheusTargetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PrometheusTargetOperationError {
    /// Kind of error that occurred.
    pub kind: PrometheusTargetOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PrometheusTargetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PrometheusTargetOperationErrorKind {
    /// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
    DocktorError(crate::error::DocktorError),
    /// Error coming from Prometheus.
    PrometheusError(crate::error::PrometheusError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PrometheusTargetOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PrometheusTargetOperationErrorKind::DocktorError(_inner) => _inner.fmt(f),
            PrometheusTargetOperationErrorKind::PrometheusError(_inner) => _inner.fmt(f),
            PrometheusTargetOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PrometheusTargetOperationError {
    fn code(&self) -> Option<&str> {
        PrometheusTargetOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PrometheusTargetOperationError {
    /// Creates a new `PrometheusTargetOperationError`.
    pub fn new(kind: PrometheusTargetOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PrometheusTargetOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PrometheusTargetOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PrometheusTargetOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PrometheusTargetOperationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PrometheusTargetOperationErrorKind::DocktorError`.
    pub fn is_docktor_error(&self) -> bool {
        matches!(
            &self.kind,
            PrometheusTargetOperationErrorKind::DocktorError(_)
        )
    }
    /// Returns `true` if the error kind is `PrometheusTargetOperationErrorKind::PrometheusError`.
    pub fn is_prometheus_error(&self) -> bool {
        matches!(
            &self.kind,
            PrometheusTargetOperationErrorKind::PrometheusError(_)
        )
    }
}
impl std::error::Error for PrometheusTargetOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PrometheusTargetOperationErrorKind::DocktorError(_inner) => Some(_inner),
            PrometheusTargetOperationErrorKind::PrometheusError(_inner) => Some(_inner),
            PrometheusTargetOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestartOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestartOperationError {
    /// Kind of error that occurred.
    pub kind: RestartOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestartOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestartOperationErrorKind {
    /// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
    DocktorError(crate::error::DocktorError),
    /// Error coming from Systemd.
    SystemdError(crate::error::SystemdError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestartOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestartOperationErrorKind::DocktorError(_inner) => _inner.fmt(f),
            RestartOperationErrorKind::SystemdError(_inner) => _inner.fmt(f),
            RestartOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestartOperationError {
    fn code(&self) -> Option<&str> {
        RestartOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestartOperationError {
    /// Creates a new `RestartOperationError`.
    pub fn new(kind: RestartOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestartOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestartOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestartOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestartOperationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestartOperationErrorKind::DocktorError`.
    pub fn is_docktor_error(&self) -> bool {
        matches!(&self.kind, RestartOperationErrorKind::DocktorError(_))
    }
    /// Returns `true` if the error kind is `RestartOperationErrorKind::SystemdError`.
    pub fn is_systemd_error(&self) -> bool {
        matches!(&self.kind, RestartOperationErrorKind::SystemdError(_))
    }
}
impl std::error::Error for RestartOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestartOperationErrorKind::DocktorError(_inner) => Some(_inner),
            RestartOperationErrorKind::SystemdError(_inner) => Some(_inner),
            RestartOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartOperationError {
    /// Kind of error that occurred.
    pub kind: StartOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartOperationErrorKind {
    /// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
    DocktorError(crate::error::DocktorError),
    /// Error coming from Systemd.
    SystemdError(crate::error::SystemdError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartOperationErrorKind::DocktorError(_inner) => _inner.fmt(f),
            StartOperationErrorKind::SystemdError(_inner) => _inner.fmt(f),
            StartOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartOperationError {
    fn code(&self) -> Option<&str> {
        StartOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartOperationError {
    /// Creates a new `StartOperationError`.
    pub fn new(kind: StartOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartOperationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartOperationErrorKind::DocktorError`.
    pub fn is_docktor_error(&self) -> bool {
        matches!(&self.kind, StartOperationErrorKind::DocktorError(_))
    }
    /// Returns `true` if the error kind is `StartOperationErrorKind::SystemdError`.
    pub fn is_systemd_error(&self) -> bool {
        matches!(&self.kind, StartOperationErrorKind::SystemdError(_))
    }
}
impl std::error::Error for StartOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartOperationErrorKind::DocktorError(_inner) => Some(_inner),
            StartOperationErrorKind::SystemdError(_inner) => Some(_inner),
            StartOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopOperationError {
    /// Kind of error that occurred.
    pub kind: StopOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopOperationErrorKind {
    /// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
    DocktorError(crate::error::DocktorError),
    /// Error coming from Systemd.
    SystemdError(crate::error::SystemdError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopOperationErrorKind::DocktorError(_inner) => _inner.fmt(f),
            StopOperationErrorKind::SystemdError(_inner) => _inner.fmt(f),
            StopOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopOperationError {
    fn code(&self) -> Option<&str> {
        StopOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopOperationError {
    /// Creates a new `StopOperationError`.
    pub fn new(kind: StopOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopOperationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopOperationErrorKind::DocktorError`.
    pub fn is_docktor_error(&self) -> bool {
        matches!(&self.kind, StopOperationErrorKind::DocktorError(_))
    }
    /// Returns `true` if the error kind is `StopOperationErrorKind::SystemdError`.
    pub fn is_systemd_error(&self) -> bool {
        matches!(&self.kind, StopOperationErrorKind::SystemdError(_))
    }
}
impl std::error::Error for StopOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopOperationErrorKind::DocktorError(_inner) => Some(_inner),
            StopOperationErrorKind::SystemdError(_inner) => Some(_inner),
            StopOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error coming from Prometheus.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrometheusError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PrometheusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrometheusError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PrometheusError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PrometheusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PrometheusError")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for PrometheusError {}
/// See [`PrometheusError`](crate::error::PrometheusError)
pub mod prometheus_error {
    /// A builder for [`PrometheusError`](crate::error::PrometheusError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PrometheusError`](crate::error::PrometheusError)
        pub fn build(self) -> crate::error::PrometheusError {
            crate::error::PrometheusError {
                message: self.message,
            }
        }
    }
}
impl PrometheusError {
    /// Creates a new builder-style object to manufacture [`PrometheusError`](crate::error::PrometheusError)
    pub fn builder() -> crate::error::prometheus_error::Builder {
        crate::error::prometheus_error::Builder::default()
    }
}

/// //////////////////////////////////// Errors //////////////////////////////////// Returned when something critical happened.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocktorError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocktorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocktorError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DocktorError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DocktorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DocktorError")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for DocktorError {}
/// See [`DocktorError`](crate::error::DocktorError)
pub mod docktor_error {
    /// A builder for [`DocktorError`](crate::error::DocktorError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DocktorError`](crate::error::DocktorError)
        pub fn build(self) -> crate::error::DocktorError {
            crate::error::DocktorError {
                message: self.message,
            }
        }
    }
}
impl DocktorError {
    /// Creates a new builder-style object to manufacture [`DocktorError`](crate::error::DocktorError)
    pub fn builder() -> crate::error::docktor_error::Builder {
        crate::error::docktor_error::Builder::default()
    }
}

/// Error coming from Systemd.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemdError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SystemdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemdError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SystemdError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SystemdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SystemdError")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for SystemdError {}
/// See [`SystemdError`](crate::error::SystemdError)
pub mod systemd_error {
    /// A builder for [`SystemdError`](crate::error::SystemdError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemdError`](crate::error::SystemdError)
        pub fn build(self) -> crate::error::SystemdError {
            crate::error::SystemdError {
                message: self.message,
            }
        }
    }
}
impl SystemdError {
    /// Creates a new builder-style object to manufacture [`SystemdError`](crate::error::SystemdError)
    pub fn builder() -> crate::error::systemd_error::Builder {
        crate::error::systemd_error::Builder::default()
    }
}

/// Error coming from Prometheus.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealtcheckError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HealtcheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealtcheckError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HealtcheckError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HealtcheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HealtcheckError")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for HealtcheckError {}
/// See [`HealtcheckError`](crate::error::HealtcheckError)
pub mod healtcheck_error {
    /// A builder for [`HealtcheckError`](crate::error::HealtcheckError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HealtcheckError`](crate::error::HealtcheckError)
        pub fn build(self) -> crate::error::HealtcheckError {
            crate::error::HealtcheckError {
                message: self.message,
            }
        }
    }
}
impl HealtcheckError {
    /// Creates a new builder-style object to manufacture [`HealtcheckError`](crate::error::HealtcheckError)
    pub fn builder() -> crate::error::healtcheck_error::Builder {
        crate::error::healtcheck_error::Builder::default()
    }
}
