// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<C, M, R = aws_smithy_client::retry::Standard> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// An ergonomic service client for `DocktorApi`.
///
/// This client allows ergonomic access to a `DocktorApi`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Constructing a Client
///
/// To construct a client, you need a few different things:
///
/// - A [`Config`](crate::Config) that specifies additional configuration
///   required by the service.
/// - A connector (`C`) that specifies how HTTP requests are translated
///   into HTTP responses. This will typically be an HTTP client (like
///   `hyper`), though you can also substitute in your own, like a mock
///   mock connector for testing.
/// - A "middleware" (`M`) that modifies requests prior to them being
///   sent to the request. Most commonly, middleware will decide what
///   endpoint the requests should be sent to, as well as perform
///   authentication and authorization of requests (such as SigV4).
///   You can also have middleware that performs request/response
///   tracing, throttling, or other middleware-like tasks.
/// - A retry policy (`R`) that dictates the behavior for requests that
///   fail and should (potentially) be retried. The default type is
///   generally what you want, as it implements a well-vetted retry
///   policy implemented in [`RetryMode::Standard`](aws_smithy_types::retry::RetryMode::Standard).
///
/// To construct a client, you will generally want to call
/// [`Client::with_config`], which takes a [`aws_smithy_client::Client`] (a
/// Smithy client that isn't specialized to a particular service),
/// and a [`Config`](crate::Config). Both of these are constructed using
/// the [builder pattern] where you first construct a `Builder` type,
/// then configure it with the necessary parameters, and then call
/// `build` to construct the finalized output type. The
/// [`aws_smithy_client::Client`] builder is re-exported in this crate as
/// [`Builder`] for convenience.
///
/// In _most_ circumstances, you will want to use the following pattern
/// to construct a client:
///
/// ```
/// use docktor_api_client::{Builder, Client, Config};
/// let raw_client =
///     Builder::dyn_https()
/// #     /*
///       .middleware(/* discussed below */)
/// #     */
/// #     .middleware_fn(|r| r)
///       .build();
/// let config = Config::builder().build();
/// let client = Client::with_config(raw_client, config);
/// ```
///
/// For the middleware, you'll want to use whatever matches the
/// routing, authentication and authorization required by the target
/// service. For example, for the standard AWS SDK which uses
/// [SigV4-signed requests], the middleware looks like this:
///
// Ignored as otherwise we'd need to pull in all these dev-dependencies.
/// ```rust,ignore
/// use aws_endpoint::AwsEndpointStage;
/// use aws_http::user_agent::UserAgentStage;
/// use aws_sig_auth::middleware::SigV4SigningStage;
/// use aws_sig_auth::signer::SigV4Signer;
/// use aws_smithy_http_tower::map_request::MapRequestLayer;
/// use tower::layer::util::Stack;
/// use tower::ServiceBuilder;
///
/// type AwsMiddlewareStack =
///     Stack<MapRequestLayer<SigV4SigningStage>,
///         Stack<MapRequestLayer<UserAgentStage>,
///             MapRequestLayer<AwsEndpointStage>>>,
///
/// #[derive(Debug, Default)]
/// pub struct AwsMiddleware;
/// impl<S> tower::Layer<S> for AwsMiddleware {
///     type Service = <AwsMiddlewareStack as tower::Layer<S>>::Service;
///
///     fn layer(&self, inner: S) -> Self::Service {
///         let signer = MapRequestLayer::for_mapper(SigV4SigningStage::new(SigV4Signer::new())); _signer: MapRequestLaye
///         let endpoint_resolver = MapRequestLayer::for_mapper(AwsEndpointStage); _endpoint_resolver: MapRequestLayer<Aw
///         let user_agent = MapRequestLayer::for_mapper(UserAgentStage::new()); _user_agent: MapRequestLayer<UserAgentSt
///         // These layers can be considered as occurring in order, that is:
///         // 1. Resolve an endpoint
///         // 2. Add a user agent
///         // 3. Sign
///         // (4. Dispatch over the wire)
///         ServiceBuilder::new() _ServiceBuilder<Identity>
///             .layer(endpoint_resolver) _ServiceBuilder<Stack<MapRequestLayer<_>, _>>
///             .layer(user_agent) _ServiceBuilder<Stack<MapRequestLayer<_>, _>>
///             .layer(signer) _ServiceBuilder<Stack<MapRequestLayer<_>, _>>
///             .service(inner)
///     }
/// }
/// ```
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<C, M, R = aws_smithy_client::retry::Standard> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`HealthcheckOperation`](crate::client::fluent_builders::HealthcheckOperation) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::HealthcheckOperation::send) it.

    /// - On success, responds with [`HealthcheckOperationOutput`](crate::output::HealthcheckOperationOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::HealthcheckOperationOutput::message): (undocumented)
    /// - On failure, responds with [`SdkError<HealthcheckOperationError>`](crate::error::HealthcheckOperationError)
    pub fn healthcheck_operation(&self) -> fluent_builders::HealthcheckOperation<C, M, R> {
        fluent_builders::HealthcheckOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOperation`](crate::client::fluent_builders::ListOperation) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ListOperation::send) it.

    /// - On success, responds with [`ListOperationOutput`](crate::output::ListOperationOutput) with field(s):
    ///   - [`primary(Option<String>)`](crate::output::ListOperationOutput::primary): Is primary?
    ///   - [`host(Option<Host>)`](crate::output::ListOperationOutput::host): Host info.
    ///   - [`resources(Option<Resources>)`](crate::output::ListOperationOutput::resources): Host resources.
    ///   - [`services(Option<Vec<Service>>)`](crate::output::ListOperationOutput::services): List of available services.
    ///   - [`checksum(Option<String>)`](crate::output::ListOperationOutput::checksum): Service checksum.
    ///   - [`available_services(Option<Vec<String>>)`](crate::output::ListOperationOutput::available_services): List of services runnable by this host
    ///   - [`peers(Option<HashMap<String, ListOutput>>)`](crate::output::ListOperationOutput::peers): Map of peers configurations
    /// - On failure, responds with [`SdkError<ListOperationError>`](crate::error::ListOperationError)
    pub fn list_operation(&self) -> fluent_builders::ListOperation<C, M, R> {
        fluent_builders::ListOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PrometheusTargetOperation`](crate::client::fluent_builders::PrometheusTargetOperation) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::PrometheusTargetOperation::send) it.

    /// - On success, responds with [`PrometheusTargetOperationOutput`](crate::output::PrometheusTargetOperationOutput) with field(s):
    ///   - [`targets(Option<Vec<PrometheusTarget>>)`](crate::output::PrometheusTargetOperationOutput::targets): List of Prometheus targets.
    /// - On failure, responds with [`SdkError<PrometheusTargetOperationError>`](crate::error::PrometheusTargetOperationError)
    pub fn prometheus_target_operation(
        &self,
    ) -> fluent_builders::PrometheusTargetOperation<C, M, R> {
        fluent_builders::PrometheusTargetOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestartOperation`](crate::client::fluent_builders::RestartOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`services(Vec<String>)`](crate::client::fluent_builders::RestartOperation::services) / [`set_services(Option<Vec<String>>)`](crate::client::fluent_builders::RestartOperation::set_services): Service name.
    ///   - [`hostname(impl Into<String>)`](crate::client::fluent_builders::RestartOperation::hostname) / [`set_hostname(Option<String>)`](crate::client::fluent_builders::RestartOperation::set_hostname): Hostname.
    /// - On success, responds with [`RestartOperationOutput`](crate::output::RestartOperationOutput) with field(s):
    ///   - [`inner(Option<Vec<SystemdOutputInner>>)`](crate::output::RestartOperationOutput::inner): Systemd output list.
    /// - On failure, responds with [`SdkError<RestartOperationError>`](crate::error::RestartOperationError)
    pub fn restart_operation(&self) -> fluent_builders::RestartOperation<C, M, R> {
        fluent_builders::RestartOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartOperation`](crate::client::fluent_builders::StartOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`services(Vec<String>)`](crate::client::fluent_builders::StartOperation::services) / [`set_services(Option<Vec<String>>)`](crate::client::fluent_builders::StartOperation::set_services): Service name.
    ///   - [`hostname(impl Into<String>)`](crate::client::fluent_builders::StartOperation::hostname) / [`set_hostname(Option<String>)`](crate::client::fluent_builders::StartOperation::set_hostname): Hostname.
    /// - On success, responds with [`StartOperationOutput`](crate::output::StartOperationOutput) with field(s):
    ///   - [`inner(Option<Vec<SystemdOutputInner>>)`](crate::output::StartOperationOutput::inner): Systemd output list.
    /// - On failure, responds with [`SdkError<StartOperationError>`](crate::error::StartOperationError)
    pub fn start_operation(&self) -> fluent_builders::StartOperation<C, M, R> {
        fluent_builders::StartOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopOperation`](crate::client::fluent_builders::StopOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`services(Vec<String>)`](crate::client::fluent_builders::StopOperation::services) / [`set_services(Option<Vec<String>>)`](crate::client::fluent_builders::StopOperation::set_services): Service name.
    ///   - [`hostname(impl Into<String>)`](crate::client::fluent_builders::StopOperation::hostname) / [`set_hostname(Option<String>)`](crate::client::fluent_builders::StopOperation::set_hostname): Hostname.
    /// - On success, responds with [`StopOperationOutput`](crate::output::StopOperationOutput) with field(s):
    ///   - [`inner(Option<Vec<SystemdOutputInner>>)`](crate::output::StopOperationOutput::inner): Systemd output list.
    /// - On failure, responds with [`SdkError<StopOperationError>`](crate::error::StopOperationError)
    pub fn stop_operation(&self) -> fluent_builders::StopOperation<C, M, R> {
        fluent_builders::StopOperation::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `HealthcheckOperation`.
    ///
    /// //////////////////////////////////// Operations //////////////////////////////////// Read-only healtcheck operation.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct HealthcheckOperation<C, M, R = aws_smithy_client::retry::Standard> {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::healthcheck_operation_input::Builder,
    }
    impl<C, M, R> HealthcheckOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `HealthcheckOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::HealthcheckOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::HealthcheckOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::HealthcheckOperationInputOperationOutputAlias,
                crate::output::HealthcheckOperationOutput,
                crate::error::HealthcheckOperationError,
                crate::input::HealthcheckOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListOperation`.
    ///
    /// Get the current status of the cluster from this node's perspective.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOperation<C, M, R = aws_smithy_client::retry::Standard> {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_operation_input::Builder,
    }
    impl<C, M, R> ListOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOperationInputOperationOutputAlias,
                crate::output::ListOperationOutput,
                crate::error::ListOperationError,
                crate::input::ListOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `PrometheusTargetOperation`.
    ///
    /// Prometheus service discovery.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PrometheusTargetOperation<C, M, R = aws_smithy_client::retry::Standard> {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::prometheus_target_operation_input::Builder,
    }
    impl<C, M, R> PrometheusTargetOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PrometheusTargetOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PrometheusTargetOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::PrometheusTargetOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PrometheusTargetOperationInputOperationOutputAlias,
                crate::output::PrometheusTargetOperationOutput,
                crate::error::PrometheusTargetOperationError,
                crate::input::PrometheusTargetOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `RestartOperation`.
    ///
    /// Stop a service.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestartOperation<C, M, R = aws_smithy_client::retry::Standard> {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restart_operation_input::Builder,
    }
    impl<C, M, R> RestartOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestartOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestartOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::RestartOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestartOperationInputOperationOutputAlias,
                crate::output::RestartOperationOutput,
                crate::error::RestartOperationError,
                crate::input::RestartOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// Service name.
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.services(input.into());
            self
        }
        /// Service name.
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_services(input);
            self
        }
        /// Hostname.
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hostname(input.into());
            self
        }
        /// Hostname.
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hostname(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartOperation`.
    ///
    /// Start a service.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartOperation<C, M, R = aws_smithy_client::retry::Standard> {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_operation_input::Builder,
    }
    impl<C, M, R> StartOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartOperationInputOperationOutputAlias,
                crate::output::StartOperationOutput,
                crate::error::StartOperationError,
                crate::input::StartOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// Service name.
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.services(input.into());
            self
        }
        /// Service name.
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_services(input);
            self
        }
        /// Hostname.
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hostname(input.into());
            self
        }
        /// Hostname.
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hostname(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopOperation`.
    ///
    /// Stop a service.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopOperation<C, M, R = aws_smithy_client::retry::Standard> {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_operation_input::Builder,
    }
    impl<C, M, R> StopOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::StopOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopOperationInputOperationOutputAlias,
                crate::output::StopOperationOutput,
                crate::error::StopOperationError,
                crate::input::StopOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// Service name.
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.services(input.into());
            self
        }
        /// Service name.
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_services(input);
            self
        }
        /// Hostname.
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hostname(input.into());
            self
        }
        /// Hostname.
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hostname(input);
            self
        }
    }
}
