*HPE Code of Conduct/Contribution Guide*

Conduct
-------
This is the official “hewlettpackard” organization on GitHub: https://github.com/hewlettpackard.

Whether you are a regular contributor or a newcomer, we care about making this community a safe place for you.

We are committed to providing a friendly, safe and welcoming environment for all regardless of their background and the extent of their contributions.

Please avoid using nicknames that might detract from a friendly, safe and welcoming environment for all. Be kind and courteous.

Those who insult, demean or harass anyone will be excluded from interaction. In particular, behavior that excludes people in socially marginalized groups will not be tolerated.

We welcome discussion about creating a welcoming, safe and productive environment for the community. If you have any questions, feedback or concerns please let us know. (github@hpe.com).

Contributing
------------
You are invited to contribute new features, fixes, or updates, large or small; we are always thrilled to receive pull requests, and do our best to process them as fast as we can.

Before you start to code, we recommend discussing your plans with the targeted project/repo through a GitHub issue, especially for more ambitious contributions. This gives other contributors a chance to point you in the right direction, give you feedback on your design, and help you find out if someone else is working on the same thing.

* If you want to contribute design assets or style guide revisions, please open a GitHub pull request or open a GitHub issue against the particular project.
* If you want to raise an issue such as a defect or an enhancement request, please open a GitHub issue for the appropriate project. Please keep the following in mind:

    * Try to reduce your code to the bare minimum required to reproduce the issue.
    * If we can't reproduce the issue, we can't fix it. Please list the exact steps required to reproduce the issue.
    
Submitting Code Pull Requests
-----------------------------
We encourage and support contributions from the community. No fix is too small. We strive to process all pull requests as soon as possible and with constructive feedback. If your pull request is not accepted at first, please try again after addressing the feedback you received.

To make a pull request you will need a GitHub account. For help, see GitHub's documentation on forking and pull requests.

All pull requests with code should include tests that validate your change.

Developer's Certificate of Origin
---------------------------------
All contributions must include acceptance of the DCO:
> Developer Certificate of Origin Version 1.1
> 
> Copyright (C) 2004, 2006 The Linux Foundation and its contributors. 660
> York Street, Suite 102, San Francisco, CA 94110 USA
> 
> Everyone is permitted to copy and distribute verbatim copies of this
> license document, but changing it is not allowed.
> 
> Developer's Certificate of Origin 1.1
> 
> By making a contribution to this project, I certify that:
> 
> \(a) The contribution was created in whole or in part by me and I have
> the right to submit it under the open source license indicated in the
> file; or
> 
> \(b) The contribution is based upon previous work that, to the best of my
> knowledge, is covered under an appropriate open source license and I
> have the right under that license to submit that work with
> modifications, whether created in whole or in part by me, under the same
> open source license (unless I am permitted to submit under a different
> license), as indicated in the file; or
> 
> \(c) The contribution was provided directly to me by some other person
> who certified (a), (b) or (c) and I have not modified it.
> 
> \(d) I understand and agree that this project and the contribution are
> public and that a record of the contribution (including all personal
> information I submit with it, including my sign-off) is maintained
> indefinitely and may be redistributed consistent with this project or
> the open source license(s) involved.

Sign your work
--------------
To accept the DCO, simply add this line to each commit message with your name and email address (git commit -s will do this for you):

    Signed-off-by: Jane Example <jane@example.com>

For legal reasons, no anonymous or pseudonymous contributions are accepted.

Other Ways to Contribute
------------------------
If you don't feel like creating design assets or writing code, you can still contribute!

1.	You may submit updates and improvements to the documentation.
2.	Submit articles and guides which are also part of the documentation.
3.	Help answer questions on StackOverflow, Slack and GitHub.

References
----------
This contribution guide was inspired by the contribution guides for [Grommet](https://github.com/grommet/grommet/blob/master/CONTRIBUTING.md) and [CloudSlang](http://www.cloudslang.io/#/docs#contributing-code).
