# Contributing to DNSimple/Rust

## Getting started

### 1. Clone the repository

Clone the repository and move into it:

```shell
git clone git@github.com:dnsimple/dnsimple-rust.git
cd dnsimple-rust
```

### 2. Build and test

[Run the test suite](#testing) to check everything works as expected.

## Releasing

The following instructions uses `$VERSION` as a placeholder, where `$VERSION` is a `MAJOR.MINOR.BUGFIX` release such as `1.2.0`.

1. Set the version in `dnsimple.rs`:

    ```rust
    const VERSION: &str = "0.1.0";
    ```
   
2. Set the version in `Cargo.toml`
 
    ```yaml
    version = "0.1.0"
    ```

4. Run the test suite and ensure all the tests pass.

5. Finalize the `## main` section in `CHANGELOG.md` assigning the version.

6. Commit and push the changes

    ```shell
    git commit -a -m "Release $VERSION"
    git push origin main
    ```

7. Wait for CI to complete.

8. Create a signed tag.

    ```shell
    git tag -a v$VERSION -s -m "Release $VERSION"
    git push origin --tags
    ```
   
9. The `release` GitHub action should take it from here and release the package to crates.io
   
## Testing

To run the test suite:

```shell
cargo test
```

## Tests

Submit unit tests for your changes. You can test your changes on your machine by [running the test suite](#testing).

When you submit a PR, tests will also be run on the [continuous integration environment via GitHub Actions](https://github.com/dnsimple/dnsimple-rust/actions).