use std::{any::TypeId, collections::HashMap};

use num_traits::Num;

// TODO: Document all items here
pub struct ScopeMap<T: Copy> {
    map: HashMap<TypeId, T>,
}

impl<T: Copy + Num> ScopeMap<T> {
    pub fn new() -> Self {
        Self {
            map: HashMap::new(),
        }
    }

    pub fn get(&mut self, scope: TypeId) -> Option<T> {
        let val_ref = self.map.get_mut(&scope)?;
        let out_val = *val_ref;
        *val_ref = *val_ref + T::one();

        Some(out_val)
    }

    // Mark unsafe?
    pub fn set(&mut self, scope: TypeId, val: T) {
        self.map.insert(scope, val);
    }

    pub fn has(&self, scope: TypeId) -> bool {
        self.map.contains_key(&scope)
    }

    pub fn peek(&self, scope: TypeId) -> Option<T> {
        self.map.get(&scope).copied()
    }
}
