use crate::scope::{GlobalScope, Scope};
use crate::Id;

macro_rules! alias_ids {
    ($($name:ident<$ty:ty>),* $(,).*) => {$(
        #[doc = concat!("Alias of [`Id`], taking generic parameter `S` and providing generic parameter [`", stringify!($ty),"`]")]
        pub trait $name<S: Scope> = Id<S, $ty>;
    )*};
}

alias_ids! {
    Id8<u8>,
    Id16<u16>,
    Id32<u32>,
    Id64<u64>,
    Id128<u128>,
    IdSize<usize>,
}

macro_rules! alias_global_ids {
    ($($name:ident<$ty:ty>),* $(,).*) => {$(
        #[doc = concat!("Alias of [`Id`] with the generic parameters [`GlobalScope`] and [`", stringify!($ty),"`]")]
        pub trait $name = Id<GlobalScope, $ty>;
    )*};
}

alias_global_ids! {
    GlobalId8<u8>,
    GlobalId16<u16>,
    GlobalId32<u32>,
    GlobalId64<u64>,
    GlobalId128<u128>,
    GlobalIdSize<usize>,
}
