use crate::{DmvId, GlobalScope};

macro_rules! alias_dmv_ids {
    ($($name:ident<$ty:ty>),* $(,).*) => {$(
        #[doc = concat!("Alias of [`DmvId`], taking scope `S` and providing generic parameter [`", stringify!($ty),"`]")]
        pub type $name<S> = DmvId<S, $ty>;
    )*};
}

alias_dmv_ids! {
    DmvId8<u8>,
    DmvId16<u16>,
    DmvId32<u32>,
    DmvId64<u64>,
    DmvId128<u128>,
    DmvIdSize<usize>,
}

macro_rules! alias_global_dmv_ids {
    ($($name:ident<$ty:ty>),* $(,).*) => {$(
        #[doc = concat!("Alias of [`DmvId`] with the generic parameters [`GlobalScope`] and [`", stringify!($ty),"`]")]
        pub type $name = DmvId<GlobalScope, $ty>;
    )*};
}

alias_global_dmv_ids! {
    GlobalDmvId8<u8>,
    GlobalDmvId16<u16>,
    GlobalDmvId32<u32>,
    GlobalDmvId64<u64>,
    GlobalDmvId128<u128>,
    GlobalDmvIdSize<usize>,
}
