use dmv::*;

#[test]
fn test_multi_scope() {
    scope!(pub Scope1);
    scope!(pub Scope2);

    Dmv.init::<Scope1, usize>(1);
    Dmv.init::<Scope2, usize>(1);

    let s1_id1 = Dmv.register::<Scope1, usize>().unwrap();
    let s1_id2 = Dmv.register::<Scope1, usize>().unwrap();
    assert_ne!(s1_id1, s1_id2);

    let s2_id1 = Dmv.register::<Scope2, usize>().unwrap();
    let s2_id2 = Dmv.register::<Scope2, usize>().unwrap();
    assert_ne!(s2_id1, s2_id2);

    assert_eq!(*s1_id1.handle(), *s2_id1.handle());
    assert_eq!(*s1_id2.handle(), *s2_id2.handle());
}

#[test]
fn test_handle() {
    let id = Dmv.register::<GlobalScope, usize>().unwrap();

    {
        let h1 = id.handle();
        let h2 = id.handle();

        assert_eq!(*h1, *h2);
    }
}

// Uncomment to analyze error
// #[test]
// fn test_handle_failure() {
//     let (h1, h2) = {
//         let id = Dmv.register::<GlobalScope, usize>().unwrap(); // `id` created here

//         (id.handle(), id.handle()) // error[E0597]: `id` does not live long enough
//     }; // `id` is dropped here

//     assert_eq!(*h1, *h2);
// }
