use dmv::*;

#[test]
fn test_multi_scope() {
    scope!(pub Scope1);
    scope!(pub Scope2);

    let s1_id1 = register::<Scope1>();
    let s1_id2 = register::<Scope1>();
    assert_ne!(s1_id1, s1_id2);

    let s2_id1 = register::<Scope2>();
    let s2_id2 = register::<Scope2>();
    assert_ne!(s2_id1, s2_id2);

    assert_eq!(s1_id1.handle().value(), s2_id1.handle().value());
    assert_eq!(s1_id2.handle().value(), s2_id2.handle().value());
}

#[test]
fn test_handle() {
    let id = register_global();

    {
        let h1 = id.handle();
        let h2 = id.handle();

        assert_eq!(h1, h2);
        assert_eq!(h1.value(), h2.value());
    }
}

// Uncomment to analyze error
// #[test]
// fn test_handle_failure() {
//     let (h1, h2) = {
//         let id = register_global(); // `id` created here
// 
//         (id.handle(), id.handle()) // error[E0597]: `id` does not live long enough
//     }; // `id` is dropped here
// 
//     assert_eq!(h1, h2);
//     assert_eq!(h1.value(), h2.value());
// }
