use dmv::*;

#[test]
fn test_multi_scope() {
    scope!(pub Scope1);
    scope!(pub Scope2);

    let s1_id1 = register::<Scope1>();
    let s1_id2 = register::<Scope1>();
    assert_ne!(s1_id1, s1_id2);

    let s2_id1 = register::<Scope2>();
    let s2_id2 = register::<Scope2>();
    assert_ne!(s2_id1, s2_id2);

    assert_eq!(s1_id1.handle().value(), s2_id1.handle().value());
    assert_eq!(s1_id2.handle().value(), s2_id2.handle().value());
}
