#![cfg_attr(not(doctest), doc = include_str!("../README.md") )]
#![feature(once_cell)]
#![warn(missing_docs)]
#![deny(rustdoc::broken_intra_doc_links)]
#![warn(clippy::pedantic)]

/// Definition of the [`Id`] struct.
pub mod identity;
/// Definition of the [`Scope`] trait.
pub mod scope;

pub use identity::{GlobalId, Id, IdHandle};
pub use scope::{GlobalScope, Scope};

#[cfg(feature = "derive")]
#[doc(hidden)]
pub use dmv_derive::*;

/// Creates a new [`Id`] with scope `S`.
#[must_use]
pub fn register<S: Scope>() -> Id<S> {
    Id::new()
}

/// Creates a new [`Id`] with scope [`GlobalScope`].
///
/// This function is equivalent to [`register::<GlobalScope>()`].
#[must_use]
pub fn register_global() -> Id<GlobalScope> {
    register()
}

#[cfg(test)]
mod tests {
    use super::*;
    use crate::scope::GlobalScope;

    #[test]
    fn test_basic() {
        let id1 = register::<GlobalScope>();
        let id2 = register::<GlobalScope>();
        assert_ne!(id1, id2);
    }

    #[test]
    fn test_global() {
        let id1 = register_global();
        let id2 = register_global();
        assert_ne!(id1, id2);
    }
}
