# Scoped IDs

This crate implements the idea of identifiers whose uniqueness is tied to a specific "scope", allowing for a common `Identity` type generic over the scope where each individual instantiation can only inter-operate with its own instantiation.

## Common Use

```rust
dmv::scope!{ pub FooScope }
type FooId = dmv::Id<FooScope>;

struct Foo {
    sid: FooId,
    gid: dmv::GlobalId,
}

dmv::scope!{ pub BarScope }
type BarId = dmv::Id<BarScope>;

struct Bar {
    sid: BarId,
    gid: dmv::GlobalId,
}
```

In the example above, the `sid` members of both `Foo` and `Bar` are different types and cannot be directly operated with each other, and the `gid` members are of the same type and are therefore interoperable.

## Future Plans

In the current state of the project it is recommended to create a new scope by using the `scope!` macro. Soon this macro will be deprecated in favor of a derive macro that can be called on any type to generate a scope and ID specifically for that type.

An example of how this would look would be:

```rust
#[derive(Dmv)]
struct MyFoo {
    // ...
}
```
would expand to something like
```rust
#[derive(Hash)]
struct MyFooScope;
impl Scope for MyFooScope {}
type MyFooId = Id<MyFooScope>;

struct MyFoo {
    // ...
}
```
