mod parser;
mod pipeline;

use std::{fs, sync::Arc};

use arrow::csv;
use arrow::datatypes::Schema;
use datafusion::{datasource::MemTable, prelude::*};

#[tokio::main]
async fn main() {
    let sql_files = parser::parse_dir();
    let pipeline = pipeline::Pipeline::new(sql_files);
    let mut ctx = ExecutionContext::new();

    for source in &pipeline.sources {
        ctx.register_csv(&source.id, &source.path, CsvReadOptions::new())
            .unwrap();
    }

    for step in pipeline.exec_order() {
        let model = pipeline.models.iter().find(|x| x.id == step).unwrap();
        let df = ctx.sql(&model.sql).unwrap();
        let results = df.collect().await.unwrap();

        for export in &model.exports {
            let out_file = fs::File::create(export).unwrap();
            let mut writer = csv::Writer::new(out_file);
            for batch in &results {
                writer.write(batch).unwrap();
            }
        }

        let schema: Schema = df.schema().to_owned().into();
        let mem_table = MemTable::try_new(Arc::new(schema), vec![results]).unwrap();
        ctx.register_table(model.id.as_str(), Arc::new(mem_table))
            .unwrap();
    }
}
