use arrow::csv;
use datafusion::prelude::*;
use glob::glob;
use std::fs;

#[tokio::main]
async fn main() -> datafusion::error::Result<()> {
    let mut ctx = ExecutionContext::new();

    for csv_file in glob("./*.csv").unwrap() {
        let path = csv_file.as_ref().unwrap().as_path();
        ctx.register_csv(
            path.file_stem().unwrap().to_str().unwrap(),
            path.to_str().unwrap(),
            CsvReadOptions::new(),
        )?;
    }

    fs::create_dir_all("./output")?;
    for sql_file in glob("./*.sql").unwrap() {
        let path = sql_file.as_ref().unwrap().as_path();
        let sql = fs::read_to_string(path)?;
        let df = ctx.sql(&sql)?;
        let results = df.collect().await?;
        let out_file_path = format!(
            "./output/{}.csv",
            path.file_stem().unwrap().to_str().unwrap()
        );
        let out_file = fs::File::create(out_file_path)?;
        let mut writer = csv::Writer::new(out_file);
        for batch in results {
            writer.write(&batch).unwrap();
        }
    }

    Ok(())
}
