/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * Decision table recognizer
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::canvas;
use crate::tests::{EX_04, EX_07};

#[test]
fn plane_pivot_horizontal() {
  let mut canvas = canvas::scan(&String::from(EX_04)).unwrap();
  let mut plane = canvas.plane().unwrap();
  let before = format!("{}", plane);
  plane.pivot();
  plane.pivot();
  let after = format!("{}", plane);
  assert_eq!(before, after);
}

#[test]
fn plane_pivot_vertical() {
  let mut canvas = canvas::scan(&String::from(EX_07)).unwrap();
  let mut plane = canvas.plane().unwrap();
  let before = format!("{}", plane);
  plane.pivot();
  plane.pivot();
  let after = format!("{}", plane);
  assert_eq!(before, after);
}
