/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_3_0034, "file: ///3_0034.dmn").unwrap();
}

#[test]
fn _0001() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(&DEFINITIONS, "decision A 1", &ctx, r#"{resolve A: "A"}"#);
}

#[test]
fn _0002() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(&DEFINITIONS, "decision A 2.1", &ctx, r#"{resolve A 1: {resolve A: "A"}}"#);
}

#[test]
fn _0003() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(&DEFINITIONS, "decision A 2.2", &ctx, r#"{resolve A 1: {resolve A: "A"}}"#);
}

#[test]
fn _0004() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(
    &DEFINITIONS,
    "decision A 3",
    &ctx,
    r#"{resolve A 2.1: {resolve A 1: {resolve A: "A"}}, resolve A 2.2: {resolve A 1: {resolve A: "A"}}}"#,
  );
}

#[test]
fn _0005() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(&DEFINITIONS, "decision B 1", &ctx, r#"{resolve A: "A", resolve B: "B"}"#);
}

#[test]
fn _0006() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(&DEFINITIONS, "decision B 2.1", &ctx, r#"{resolve B 1: {resolve A: "A", resolve B: "B"}}"#);
}

#[test]
fn _0007() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(&DEFINITIONS, "decision B 2.2", &ctx, r#"{resolve B 1: {resolve A: "A", resolve B: "B"}}"#);
}

#[test]
fn _0008() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(
    &DEFINITIONS,
    "decision B 3",
    &ctx,
    r#"{resolve A 3: {resolve A 2.1: {resolve A 1: {resolve A: "A"}}, resolve A 2.2: {resolve A 1: {resolve A: "A"}}}, resolve B 2.1: {resolve B 1: {resolve A: "A", resolve B: "B"}}, resolve B 2.2: {resolve B 1: {resolve A: "A", resolve B: "B"}}}"#,
  );
}

#[test]
fn _0009() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(
    &DEFINITIONS,
    "decision C 1",
    &ctx,
    r#"{resolve A 3: {resolve A 2.1: {resolve A 1: {resolve A: "A"}}, resolve A 2.2: {resolve A 1: {resolve A: "A"}}}, resolve B 3: {resolve A 3: {resolve A 2.1: {resolve A 1: {resolve A: "A"}}, resolve A 2.2: {resolve A 1: {resolve A: "A"}}}, resolve B 2.1: {resolve B 1: {resolve A: "A", resolve B: "B"}}, resolve B 2.2: {resolve B 1: {resolve A: "A", resolve B: "B"}}}, resolve C: "C"}"#,
  );
}

#[test]
fn _0010() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(
    &DEFINITIONS,
    "decision C 2",
    &ctx,
    r#""BKM I # BKM II # BKM III # decision C 2 # BKM IV # BKM III # decision C 2""#,
  );
}

#[test]
fn _0011() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(
    &DEFINITIONS,
    "decision C 3",
    &ctx,
    r#""BKM II # BKM III # decision C 3 # BKM IV # BKM III # decision C 3""#,
  );
}

#[test]
fn _0012() {
  let ctx = context(r#"{A: "A",B: "B",C: "C"}"#);
  assert_decision(
    &DEFINITIONS,
    "decision C 4",
    &ctx,
    r#"{resolve C 3: "BKM II # BKM III # decision C 3 # BKM IV # BKM III # decision C 3"}"#,
  );
}
