/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_3_0006, "file: ///3_0006.dmn").unwrap();
}

const INPUT_DATA: &str = r#"
  {
    DeptTable:  [
      {
        manager: "Smith",
        name: "Sales",
        number: 10
      },
      {
        manager: "Jones",
        name: "Finance",
        number: 20
      },
      {
        manager: "King",
        name: "Engineering",
        number: 30
      }
    ],
    EmployeeTable:  [
      {
        deptNum: 10,
        id: "7792",
        name: "Clark"
      },
      {
        deptNum: 10,
        id: "7934",
        name: "Miller"
      },
      {
        deptNum: 20,
        id: "7976",
        name: "Adams"
      },
      {
        deptNum: 20,
        id: "7902",
        name: "Ford"
      },
      {
        deptNum: 30,
        id: "7900",
        name: "James"
      }
    ],
    LastName: "Clark"
  }
"#;

#[test]
fn _0001() {
  let ctx = context(INPUT_DATA);
  assert_decision(&DEFINITIONS, "Join", &ctx, r#""Smith""#);
}
