/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, assert_decision_service, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_3_0085, "file: ///3_0085.dmn").unwrap();
}

#[test]
fn _0001() {
  assert_decision_service(&DEFINITIONS, "decisionService_001", r#"{}"#, r#""foo""#);
}

#[test]
fn _0002() {
  assert_decision_service(&DEFINITIONS, "decisionService_002", r#"{decision_002_input: "baz"}"#, r#""foo baz""#);
}

#[test]
fn _0002_a() {
  assert_decision_service(&DEFINITIONS, "decisionService_002", r#"{}"#, r#"null(addition err 2)"#);
}

#[test]
fn _0002_b() {
  assert_decision_service(&DEFINITIONS, "decisionService_002", r#"{decision_002_input: null}"#, r#"null(addition err 2)"#);
}

#[test]
fn _0002_c() {
  assert_decision_service(&DEFINITIONS, "decisionService_002", r#"{decision_002_input: 1234}"#, r#"null(addition err 2)"#);
}

#[test]
fn _0003() {
  assert_decision_service(
    &DEFINITIONS,
    "decisionService_003",
    r#"{decision_003_input_1: "B", decision_003_input_2: "C", inputData_003: "D"}"#,
    r#""A B C D""#,
  );
}

#[test]
fn _0004() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "decision_004_1", &ctx, r#""foo""#);
}

#[test]
#[ignore]
fn _0005() {
  assert_decision_service(&DEFINITIONS, "decisionService_005", r#"{}"#, r#"null"#);
}
