/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_3_0041, "file: ///3_0041.dmn").unwrap();
}

#[test]
fn _0001() {
  let ctx = context(r#"{Principal: 600000,Term: 360}"#);
  assert_decision(&DEFINITIONS, "Boxed Context", &ctx, r#"2778.6935494327667680885203832"#);
}

#[test]
fn _0002() {
  let ctx = context(r#"{Principal: 30000,Term: 60}"#);
  assert_decision(&DEFINITIONS, "Boxed Context", &ctx, r#"549.11754983640029349270001464"#);
}

#[test]
fn _0003() {
  let ctx = context(r#"{Principal: 600000,Term: 365}"#);
  assert_decision(&DEFINITIONS, "Boxed Context", &ctx, r#"2758.1160998965914008714188932"#);
}
