/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::errors::*;
use crate::model_evaluator::ModelEvaluator;
use dmntk_common::Result;
use dmntk_feel::context::FeelContext;
use dmntk_feel::values::Value;
use dmntk_model::model::*;

/// Evaluates a [Decision] defined by specified name.
pub fn evaluate_decision_by_name(definitions: &Definitions, name: &str, input_data: &FeelContext) -> Result<Value> {
  if let Some(decision) = definitions.decision_by_name(name) {
    // println!("AAA: <DECISION_NAME> = {}", decision.name());
    // println!("AAA: <INPUT_DATA>    = {}", input_data);
    let id = decision.id().as_ref().ok_or_else(err_empty_identifier)?;
    let model_evaluator = ModelEvaluator::new(definitions)?;
    let result = model_evaluator.evaluate_decision(id, input_data);
    Ok(result)
  } else {
    Err(err_decision_with_name_not_found(name))
  }
}
