/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_3_0002, "file: ///3_0002.dmn").unwrap();
}

#[test]
fn _0001() {
  let ctx = context(r#"{A: "banana", B: "a", NumC: 2}"#);
  assert_decision(
    &DEFINITIONS,
    "Basic",
    &ctx,
    r#"{containsB: true, containsX: false, endsWithB: true, endsWithX: false, lowercase: "a", startsWithB: false, startsWithX: false, stringlength: 6, substringAfterB: "nana", substringBeforeB: "b", substringC1: "a", uppercase: "BANANA"}"#,
  );
}

#[test]
fn _0002() {
  let ctx = context(r#"{A: "banana"}"#);
  assert_decision(&DEFINITIONS, "Matches", &ctx, r#"true"#);
}

#[test]
fn _0003() {
  let ctx = context(r#"{A: "banana"}"#);
  assert_decision(
    &DEFINITIONS,
    "Replace",
    &ctx,
    r#"{AanplusStarstar: "b**a", Aao: "bonono", encloseVowels: "b[a]n[a]n[a]"}"#,
  );
}

#[test]
fn _0004() {
  let ctx = context(r#"{NumC: 2}"#);
  assert_decision(&DEFINITIONS, "Constructor", &ctx, r#""2""#);
}
