/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_2_0008, "file: ///2_0008.dmn").unwrap();
}

#[test]
fn _0001() {
  let ctx = context(r#"{loan: {principal: 600000,rate: 0.0375,termMonths: 360}}"#);
  assert_decision(&DEFINITIONS, "payment", &ctx, r#"2778.6935494327667680885203832"#);
}

#[test]
fn _0002() {
  let ctx = context(r#"{loan: {principal: 30000,rate: 0.0475,termMonths: 60}}"#);
  assert_decision(&DEFINITIONS, "payment", &ctx, r#"562.70735937326592715621433136"#);
}

#[test]
fn _0003() {
  let ctx = context(r#"{loan: {principal: 600000,rate: 0.0399,termMonths: 360}}"#);
  assert_decision(&DEFINITIONS, "payment", &ctx, r#"2861.03377700390163671626278"#);
}
