/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::errors::*;
use crate::model_evaluator::ModelEvaluator;
use dmntk_common::Result;
use dmntk_feel::context::FeelContext;
use dmntk_feel::values::Value;
use dmntk_model::model::{Definitions, DmnElement, NamedElement};

/// Evaluates a decision service specified by name.
pub fn eval_decision_service_by_name(definitions: &Definitions, name: &str, input_data: &FeelContext) -> Result<Value> {
  if let Some(decision_service) = definitions.decision_service_by_name(name) {
    println!("AAA: <DECISION_SERVICE_NAME> = {}", decision_service.name());
    println!("AAA: <INPUT_DATA>    = {}", input_data);
    let id = decision_service.id().as_ref().ok_or_else(err_empty_identifier)?;
    let model_evaluator = ModelEvaluator::new(definitions)?;
    let result = model_evaluator.evaluate_decision_service(id, input_data);
    Ok(result)
  } else {
    Err(err_decision_service_with_name_not_found(name))
  }
}
