/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_3_1109, "file: ///3_1109.dmn").unwrap();
}

#[test]
fn _0001() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_001_7637e5a8ed", &ctx, r#""[1=ab][2=]cd""#);
}

#[test]
fn _0002() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_002_b5c242ccd4", &ctx, r#""a""#);
}

#[test]
fn _0003() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_003_bf7aa95050", &ctx, r##""#""##);
}

#[test]
fn _0004() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_004_55a2186006", &ctx, r#""abc""#);
}

#[test]
fn _0005() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_005_271d93aa68", &ctx, r#""abc""#);
}

#[test]
fn _0006() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_006_9cd005d2e2", &ctx, r##""#ar""##);
}

#[test]
fn _0007() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_007_91583e38c9", &ctx, r#""abc""#);
}

#[test]
fn _0008() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_008_8c7c3871f8", &ctx, r#""a*cada*""#);
}

#[test]
fn _0009() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_009_b1e4220bc9", &ctx, r#""*""#);
}

#[test]
fn _0010() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_010_cd4e7a6d9f", &ctx, r#""*c*bra""#);
}

#[test]
fn _0011() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_011_c310665f57", &ctx, r#""brcdbr""#);
}

#[test]
fn _0012() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_012_b0cf9e6723", &ctx, r#""abbraccaddabbra""#);
}

#[test]
fn _0013() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_013_f669d03fa9", &ctx, r#""b""#);
}

#[test]
fn _0014() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_014_cea33baeee", &ctx, r#""bbbb""#);
}

#[test]
fn _0015() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_015_57ce78ec8a", &ctx, r#""carted""#);
}

#[test]
fn _0016() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_016_1c38095f50", &ctx, r#""Xant""#);
}

#[test]
fn _0017() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_017_b9c3c03b87", &ctx, r#""(012) 345-6789""#);
}

#[test]
fn _0018() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_018_aba3349043", &ctx, r#""facet[i][o][u]sl[y]""#);
}

#[test]
fn _0019() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_019_6ef91033ad", &ctx, r####""###""####);
}

#[test]
fn _0020() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_020_52d93a8851", &ctx, r##""#.#.#.""##);
}

#[test]
fn _0021() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_021_e33828e3da", &ctx, r####""###""####);
}

#[test]
fn _0022() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_022_bd75fac0bd", &ctx, r####""###""####);
}

#[test]
fn _0023() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_023_5c337d3725", &ctx, r##""# # # #""##);
}

#[test]
fn _0024() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_024_4a89220cd6", &ctx, r#""abc""#);
}

#[test]
fn _0025() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_025_b7f9525875", &ctx, r####""###""####);
}

#[test]
fn _0026() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_026_acb176590a", &ctx, r#""abc""#);
}

#[test]
fn _0027() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_027_d8d25f40e5", &ctx, r####""###""####);
}

#[test]
fn _0028() {
  let ctx = context(r#"{}"#);
  assert_decision(&DEFINITIONS, "feel-replace-function_028_96e8c698af", &ctx, r#""abc""#);
}
