/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_3_0032, "file: ///3_0032.dmn").unwrap();
}

#[test]
fn _0001() {
  let ctx = context(r#"{bool: true,num: 100}"#);
  assert_decision(&DEFINITIONS, "simpleIf", &ctx, r#"110"#);
}

#[test]
fn _0002() {
  let ctx = context(r#"{bool: false,num: 100}"#);
  assert_decision(&DEFINITIONS, "simpleIf", &ctx, r#"90"#);
}

#[test]
fn _0003() {
  let ctx = context(r#"{bool: null,num: 100}"#);
  assert_decision(&DEFINITIONS, "simpleIf", &ctx, r#"90"#);
}

#[test]
fn _0004() {
  let ctx = context(r#"{aDate: @"2017-01-02",aString: "Hello World"}"#);
  assert_decision(&DEFINITIONS, "conditionWithFunctions", &ctx, r#""Hello""#);
}

#[test]
fn _0005() {
  let ctx = context(r#"{aDate: @"2017-01-01",aString: "Hello World"}"#);
  assert_decision(&DEFINITIONS, "conditionWithFunctions", &ctx, r#""World""#);
}

#[test]
fn _0006() {
  let ctx = context(r#"{aDate: null,aString: "Hello World"}"#);
  assert_decision(&DEFINITIONS, "conditionWithFunctions", &ctx, r#""World""#);
}
