/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_3_0017, "file: ///3_0017.dmn").unwrap();
}

#[test]
fn _0001() {
  let ctx = context(r#"{structA: {name: "widget",price: 20}}"#);
  assert_decision(&DEFINITIONS, "priceGt10", &ctx, r#"true"#);
}

#[test]
fn _0002() {
  let ctx = context(r#"{numB: 9,numC: 10,structA: {name: "widget",price: 20}}"#);
  assert_decision(&DEFINITIONS, "priceInRange", &ctx, r#""Not in range""#);
}

#[test]
fn _0003() {
  let ctx = context(r#"{dateD: @"2016-11-01"}"#);
  assert_decision(&DEFINITIONS, "dateCompare1", &ctx, r#"true"#);
}

#[test]
fn _0004() {
  let ctx = context(r#"{dateD: @"2016-11-01",dateE: @"2016-11-02"}"#);
  assert_decision(&DEFINITIONS, "dateCompare2", &ctx, r#"false"#);
}
