/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{assert_decision, context};

lazy_static! {
  static ref DEFINITIONS: dmntk_model::model::Definitions = dmntk_model::parse(dmntk_examples::DMN_2_0106, "file: ///2_0106.dmn").unwrap();
}

#[test]
fn _0001() {
  let ctx = context(r#"{A: true,B: true}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"true"#);
}

#[test]
fn _0002() {
  let ctx = context(r#"{A: true,B: true}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"true"#);
}

#[test]
fn _0003() {
  let ctx = context(r#"{A: false,B: true}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"false"#);
}

#[test]
fn _0004() {
  let ctx = context(r#"{A: false,B: true}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"true"#);
}

#[test]
fn _0005() {
  let ctx = context(r#"{A: null,B: true}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"null"#);
}

#[test]
fn _0006() {
  let ctx = context(r#"{A: null,B: true}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"true"#);
}

#[test]
fn _0007() {
  let ctx = context(r#"{A: true,B: false}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"false"#);
}

#[test]
fn _0008() {
  let ctx = context(r#"{A: true,B: false}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"true"#);
}

#[test]
fn _0009() {
  let ctx = context(r#"{A: false,B: false}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"false"#);
}

#[test]
fn _0010() {
  let ctx = context(r#"{A: false,B: false}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"false"#);
}

#[test]
fn _0011() {
  let ctx = context(r#"{A: null,B: false}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"false"#);
}

#[test]
fn _0012() {
  let ctx = context(r#"{A: null,B: false}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"null"#);
}

#[test]
fn _0013() {
  let ctx = context(r#"{A: true,B: null}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"null"#);
}

#[test]
fn _0014() {
  let ctx = context(r#"{A: true,B: null}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"true"#);
}

#[test]
fn _0015() {
  let ctx = context(r#"{A: false,B: null}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"false"#);
}

#[test]
fn _0016() {
  let ctx = context(r#"{A: false,B: null}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"null"#);
}

#[test]
fn _0017() {
  let ctx = context(r#"{A: null,B: null}"#);
  assert_decision(&DEFINITIONS, "DecisionAnd", &ctx, r#"null"#);
}

#[test]
fn _0018() {
  let ctx = context(r#"{A: null,B: null}"#);
  assert_decision(&DEFINITIONS, "DecisionOr", &ctx, r#"null"#);
}
