/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * DMN model evaluator
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

extern crate dmntk_common;
extern crate dmntk_feel;
extern crate dmntk_feel_parser;
extern crate dmntk_model;
extern crate dmntk_recognizer;
#[macro_use]
extern crate thiserror;

mod builders;
mod errors;
mod eval;
mod eval_bkm;
mod eval_dec;
mod eval_dec_service;
mod eval_dec_table;

pub use eval_bkm::evaluate_business_knowledge_model_by_name;
pub use eval_dec::evaluate_decision_by_name;
pub use eval_dec_service::eval_decision_service_by_name;
pub use eval_dec_table::{evaluate_decision_table_and_context, evaluate_decision_table_and_test};
