/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/// Definitions of date and time errors.
pub mod errors {
  use dmntk_common::DmntkError;

  /// Date and time errors.
  #[derive(Debug, PartialEq)]
  enum FeelDateTimeError {
    InvalidDateTimeLiteral(String),
  }

  //TODO https://github.com/EngosSoftware/dmntk/issues/1
  impl From<FeelDateTimeError> for DmntkError {
    fn from(e: FeelDateTimeError) -> Self {
      DmntkError::new("FeelDateTimeError", &format!("{}", e))
    }
  }

  impl std::fmt::Display for FeelDateTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
      match self {
        FeelDateTimeError::InvalidDateTimeLiteral(literal) => {
          write!(f, "invalid date and time literal: {}", literal)
        }
      }
    }
  }

  pub fn invalid_date_time_literal(literal: String) -> DmntkError {
    FeelDateTimeError::InvalidDateTimeLiteral(literal).into()
  }
}
