/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/// Definitions of time errors.
pub mod errors {
  use dmntk_common::DmntkError;

  /// Time errors.
  #[derive(Debug, PartialEq)]
  enum FeelTimeError {
    InvalidTimeLiteral(String),
  }

  //TODO https://github.com/EngosSoftware/dmntk/issues/1
  impl From<FeelTimeError> for DmntkError {
    fn from(e: FeelTimeError) -> Self {
      DmntkError::new("FeelTimeError", &format!("{}", e))
    }
  }

  impl std::fmt::Display for FeelTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
      match self {
        FeelTimeError::InvalidTimeLiteral(literal) => {
          write!(f, "invalid time literal: {}", literal)
        }
      }
    }
  }

  pub fn invalid_time_literal(literal: String) -> DmntkError {
    FeelTimeError::InvalidTimeLiteral(literal).into()
  }
}
