/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * MIT license
 *
 * Copyright (c) 2018-2022 Dariusz Depta Engos Software
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Apache license, Version 2.0
 *
 * Copyright (c) 2018-2022 Dariusz Depta Engos Software
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//! `FEEL` definitions.

extern crate ascii_tree;
extern crate chrono;
extern crate chrono_tz;
#[macro_use]
extern crate derivative;
extern crate dmntk_common;
extern crate dmntk_feel_number;
#[macro_use]
extern crate lazy_static;
extern crate regex;
#[macro_use]
extern crate thiserror;

pub use ast::{AstNode, OptAstNode};
pub use dmntk_feel_number::FeelNumber;
pub use evaluator::Evaluator;
pub use function::FunctionBody;
pub use names::Name;
pub use qualified_names::QualifiedName;
pub use scope::Scope;
pub use strings::ToFeelString;
pub use temporal::date::FeelDate;
pub use temporal::dt_duration::FeelDaysAndTimeDuration;
pub use temporal::ym_duration::FeelYearsAndMonthsDuration;
pub use temporal::{subtract, FeelDateTime, FeelTime};
pub use types::{is_built_in_type_name, FeelType};

mod ast;
mod ast_tree;
pub mod bif;
pub mod context;
mod evaluator;
mod function;
mod names;
mod qualified_names;
mod scope;
mod strings;
mod temporal;
mod types;
pub mod values;
