/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL definitions.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! `FEEL` definitions.

extern crate ascii_tree;
extern crate chrono;
extern crate chrono_tz;
#[macro_use]
extern crate derivative;
extern crate dmntk_common;
#[macro_use]
extern crate lazy_static;
extern crate regex;
extern crate rust_decimal;
extern crate rust_decimal_macros;
#[macro_use]
extern crate thiserror;

pub use ast::{AstNode, OptAstNode};
pub use evaluator::Evaluator;
pub use function::FunctionBody;
pub use names::{Name, OptName, QualifiedName};
pub use numbers::FeelNumber;
pub use scope::Scope;
pub use strings::ToFeelString;
pub use temporal::date::FeelDate;
pub use temporal::dt_duration::FeelDaysAndTimeDuration;
pub use temporal::ym_duration::FeelYearsAndMonthsDuration;
pub use temporal::{subtract, FeelDateTime, FeelTime};
pub use types::{is_built_in_type_name, FeelType};

mod ast;
mod ast_tree;
pub mod bif;
pub mod context;
mod evaluator;
mod function;
mod names;
mod numbers;
mod scope;
mod strings;
mod temporal;
mod types;
pub mod values;
