/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL definitions.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! `FEEL` and `DMN` evaluator.

use crate::values::Value;
use crate::Scope;

/// Type alias of the function that evaluates `FEEL` expression or `DMN` model into [Value].
pub type Evaluator = Box<dyn Fn(&Scope) -> Value>;

#[cfg(test)]
mod tests {
  use crate::values::Value;
  use crate::{value_number, Evaluator, FeelNumber, Scope};

  #[test]
  fn _0001() {
    let scope = Scope::default();
    let evaluator: Evaluator = Box::new(|_: &Scope| value_number!(123, 1));
    assert_eq!("12.3", evaluator(&scope).to_string());
  }
}
